/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class CSVRecordReader
implements RecordReader {
    private final CSVParser csvParser;
    private final RecordSchema schema;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public CSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, String dateFormat, String timeFormat, String timestampFormat) throws IOException {
        this.schema = schema;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(in));
        CSVFormat withHeader = csvFormat.withHeader(schema.getFieldNames().toArray(new String[0]));
        this.csvParser = new CSVParser((Reader)reader, withHeader);
    }

    public Record nextRecord() throws IOException, MalformedRecordException {
        RecordSchema schema = this.getSchema();
        Iterator iterator = this.csvParser.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            HashMap<String, Object> rowValues = new HashMap<String, Object>(schema.getFieldCount());
            for (RecordField recordField : schema.getFields()) {
                String rawValue = null;
                String fieldName = recordField.getFieldName();
                if (csvRecord.isSet(fieldName)) {
                    rawValue = csvRecord.get(fieldName);
                } else {
                    for (String alias : recordField.getAliases()) {
                        if (!csvRecord.isSet(alias)) continue;
                        rawValue = csvRecord.get(alias);
                        break;
                    }
                }
                if (rawValue == null) {
                    rowValues.put(fieldName, null);
                    continue;
                }
                Object converted = this.convert(rawValue, recordField.getDataType(), fieldName);
                if (converted == null) continue;
                rowValues.put(fieldName, converted);
            }
            return new MapRecord(schema, rowValues);
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    protected Object convert(String value, DataType dataType, String fieldName) {
        String trimmed;
        if (dataType == null || value == null) {
            return value;
        }
        String string = trimmed = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        if (trimmed.isEmpty()) {
            return null;
        }
        return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
    }

    public void close() throws IOException {
        this.csvParser.close();
    }
}

