/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;

public class WriteCSVResult
extends AbstractRecordSetWriter
implements RecordSetWriter {
    private final RecordSchema recordSchema;
    private final SchemaAccessWriter schemaWriter;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;
    private final CSVPrinter printer;
    private final Object[] fieldValues;

    public WriteCSVResult(CSVFormat csvFormat, RecordSchema recordSchema, SchemaAccessWriter schemaWriter, OutputStream out, String dateFormat, String timeFormat, String timestampFormat, boolean includeHeaderLine) throws IOException {
        super(out);
        this.recordSchema = recordSchema;
        this.schemaWriter = schemaWriter;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.timestampFormat = timestampFormat;
        String[] columnNames = recordSchema.getFieldNames().toArray(new String[0]);
        CSVFormat formatWithHeader = csvFormat.withHeader(columnNames).withSkipHeaderRecord(!includeHeaderLine);
        OutputStreamWriter streamWriter = new OutputStreamWriter(out);
        this.printer = new CSVPrinter((Appendable)streamWriter, formatWithHeader);
        this.fieldValues = new Object[recordSchema.getFieldCount()];
    }

    private String getFormat(RecordField field) {
        DataType dataType = field.getDataType();
        switch (dataType.getFieldType()) {
            case DATE: {
                return this.dateFormat;
            }
            case TIME: {
                return this.timeFormat;
            }
            case TIMESTAMP: {
                return this.timestampFormat;
            }
        }
        return dataType.getFormat();
    }

    protected void onBeginRecordSet() throws IOException {
        this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    public void close() throws IOException {
        this.printer.close();
    }

    public void flush() throws IOException {
        this.printer.flush();
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        int i = 0;
        for (RecordField recordField : this.recordSchema.getFields()) {
            this.fieldValues[i++] = record.getAsString(recordField, this.getFormat(recordField));
        }
        this.printer.printRecord(this.fieldValues);
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    public String getMimeType() {
        return "text/csv";
    }
}

