/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.grok;

import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class GrokRecordReader
implements RecordReader {
    private final BufferedReader reader;
    private final Grok grok;
    private final boolean append;
    private RecordSchema schema;
    private String nextLine;
    static final String STACK_TRACE_COLUMN_NAME = "stackTrace";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("^\\s*(?:(?:    |\\t)+at )|(?:(?:    |\\t)+\\[CIRCULAR REFERENCE\\:)|(?:Caused by\\: )|(?:Suppressed\\: )|(?:\\s+... \\d+ (?:more|common frames? omitted)$)");

    public GrokRecordReader(InputStream in, Grok grok, RecordSchema schema, boolean append) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.grok = grok;
        this.schema = schema;
        this.append = append;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Record nextRecord() throws IOException, MalformedRecordException {
        String line = this.nextLine == null ? this.reader.readLine() : this.nextLine;
        this.nextLine = null;
        if (line == null) {
            return null;
        }
        RecordSchema schema = this.getSchema();
        Match match = this.grok.match(line);
        match.captures();
        Map valueMap = match.toMap();
        if (valueMap.isEmpty()) {
            return new MapRecord(schema, Collections.emptyMap());
        }
        String stackTrace = null;
        StringBuilder toAppend = new StringBuilder();
        while ((this.nextLine = this.reader.readLine()) != null) {
            Match nextLineMatch = this.grok.match(this.nextLine);
            nextLineMatch.captures();
            Map nextValueMap = nextLineMatch.toMap();
            if (!nextValueMap.isEmpty()) break;
            if (this.isStartOfStackTrace(this.nextLine)) {
                stackTrace = this.readStackTrace(this.nextLine);
                break;
            }
            if (!this.append) continue;
            toAppend.append("\n").append(this.nextLine);
        }
        try {
            List fieldTypes = schema.getDataTypes();
            HashMap<String, Object> values = new HashMap<String, Object>(fieldTypes.size());
            for (RecordField field : schema.getFields()) {
                Object value = valueMap.get(field.getFieldName());
                if (value == null) {
                    String alias;
                    Iterator iterator = field.getAliases().iterator();
                    while (iterator.hasNext() && (value = valueMap.get(alias = (String)iterator.next())) == null) {
                    }
                }
                String fieldName = field.getFieldName();
                if (value == null) {
                    values.put(fieldName, null);
                    continue;
                }
                DataType fieldType = field.getDataType();
                Object converted = this.convert(fieldType, value.toString(), fieldName);
                values.put(fieldName, converted);
            }
            if (this.append && toAppend.length() > 0) {
                String lastFieldName = schema.getField(schema.getFieldCount() - 1).getFieldName();
                int fieldIndex = STACK_TRACE_COLUMN_NAME.equals(lastFieldName) ? schema.getFieldCount() - 2 : schema.getFieldCount() - 1;
                String lastFieldBeforeStackTrace = (String)schema.getFieldNames().get(fieldIndex);
                Object existingValue = values.get(lastFieldBeforeStackTrace);
                String updatedValue = existingValue == null ? toAppend.toString() : existingValue + toAppend.toString();
                values.put(lastFieldBeforeStackTrace, updatedValue);
            }
            values.put(STACK_TRACE_COLUMN_NAME, stackTrace);
            return new MapRecord(schema, values);
        }
        catch (Exception e) {
            throw new MalformedRecordException("Found invalid log record and will skip it. Record: " + line, (Throwable)e);
        }
    }

    private boolean isStartOfStackTrace(String line) {
        if (line == null) {
            return false;
        }
        int index = line.indexOf("Exception: ");
        if (index < 0) {
            index = line.indexOf("Error: ");
        }
        if (index < 0) {
            return false;
        }
        return line.indexOf(" ") >= index;
    }

    private String readStackTrace(String firstLine) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder(firstLine);
        while ((line = this.reader.readLine()) != null) {
            if (this.isLineInStackTrace(line)) {
                sb.append("\n").append(line);
                continue;
            }
            this.nextLine = line;
            break;
        }
        return sb.toString();
    }

    private boolean isLineInStackTrace(String line) {
        return STACK_TRACE_PATTERN.matcher(line).find();
    }

    protected Object convert(DataType fieldType, String string, String fieldName) {
        if (fieldType == null) {
            return string;
        }
        if (string == null) {
            return null;
        }
        if (string.isEmpty() && fieldType.getFieldType() != RecordFieldType.STRING) {
            return null;
        }
        return DataTypeUtils.convertType((Object)string, (DataType)fieldType, (String)fieldName);
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

