/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.json.WriteJsonResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.DateTimeTextRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"json", "resultset", "writer", "serialize", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the results of a RecordSet as a JSON Array. Even if the RecordSet consists of a single row, it will be written as an array with a single element.")
public class JsonRecordSetWriter
extends DateTimeTextRecordSetWriter
implements RecordSetWriterFactory {
    static final PropertyDescriptor PRETTY_PRINT_JSON = new PropertyDescriptor.Builder().name("Pretty Print JSON").description("Specifies whether or not the JSON should be pretty printed").expressionLanguageSupported(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    private boolean prettyPrint;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(PRETTY_PRINT_JSON);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.prettyPrint = context.getProperty(PRETTY_PRINT_JSON).asBoolean();
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, FlowFile flowFile, OutputStream out) throws SchemaNotFoundException, IOException {
        return new WriteJsonResult(logger, schema, this.getSchemaAccessWriter(schema), out, this.prettyPrint, this.getDateFormat().orElse(null), this.getTimeFormat().orElse(null), this.getTimestampFormat().orElse(null));
    }
}

