/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroReaderWithEmbeddedSchema;
import org.apache.nifi.avro.AvroReaderWithExplicitSchema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.EmbeddedAvroSchemaAccessStrategy;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"avro", "parse", "record", "row", "reader", "delimited", "comma", "separated", "values"})
@CapabilityDescription(value="Parses Avro data and returns each Avro record as an separate Record object. The Avro data may contain the schema itself, or the schema can be externalized and accessed by one of the methods offered by the 'Schema Access Strategy' property.")
public class AvroReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private final AllowableValue EMBEDDED_AVRO_SCHEMA = new AllowableValue("embedded-avro-schema", "Use Embedded Avro Schema", "The FlowFile has the Avro Schema embedded within the content, and this schema will be used.");
    private static final int MAX_AVRO_SCHEMA_CACHE_SIZE = 20;
    private final Map<String, Schema> compiledAvroSchemaCache = new LinkedHashMap<String, Schema>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Schema> eldest) {
            return this.size() >= 20;
        }
    };

    @Override
    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(this.EMBEDDED_AVRO_SCHEMA);
        return allowableValues;
    }

    @Override
    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, ConfigurationContext context) {
        if (this.EMBEDDED_AVRO_SCHEMA.getValue().equals(strategy)) {
            return new EmbeddedAvroSchemaAccessStrategy();
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    @Override
    protected SchemaAccessStrategy getSchemaAccessStrategy(String allowableValue, SchemaRegistry schemaRegistry, ValidationContext context) {
        if (this.EMBEDDED_AVRO_SCHEMA.getValue().equals(allowableValue)) {
            return new EmbeddedAvroSchemaAccessStrategy();
        }
        return super.getSchemaAccessStrategy(allowableValue, schemaRegistry, context);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        Schema avroSchema;
        String schemaAccessStrategy = this.getConfigurationContext().getProperty(this.getSchemaAcessStrategyDescriptor()).getValue();
        if (this.EMBEDDED_AVRO_SCHEMA.getValue().equals(schemaAccessStrategy)) {
            return new AvroReaderWithEmbeddedSchema(in);
        }
        RecordSchema recordSchema = this.getSchema(variables, in, null);
        try {
            Optional textOption;
            avroSchema = recordSchema.getSchemaFormat().isPresent() & ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? this.compileAvroSchema((String)textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
        }
        catch (Exception e) {
            throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
        }
        return new AvroReaderWithExplicitSchema(in, recordSchema, avroSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema compileAvroSchema(String text) {
        Schema compiled;
        AvroReader avroReader = this;
        synchronized (avroReader) {
            compiled = this.compiledAvroSchemaCache.get(text);
        }
        if (compiled != null) {
            return compiled;
        }
        Schema newlyCompiled = new Schema.Parser().parse(text);
        AvroReader avroReader2 = this;
        synchronized (avroReader2) {
            return this.compiledAvroSchemaCache.computeIfAbsent(text, t -> newlyCompiled);
        }
    }

    @Override
    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return this.EMBEDDED_AVRO_SCHEMA;
    }
}

