/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.WriteAvroResultWithExternalSchema;
import org.apache.nifi.avro.WriteAvroResultWithSchema;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"avro", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the contents of a RecordSet in Binary Avro format.")
public class AvroRecordSetWriter
extends SchemaRegistryRecordSetWriter
implements RecordSetWriterFactory {
    private static final Set<SchemaField> requiredSchemaFields = EnumSet.of(SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);
    private static final int MAX_AVRO_SCHEMA_CACHE_SIZE = 20;
    private static final PropertyDescriptor COMPRESSION_FORMAT = new PropertyDescriptor.Builder().name("compression-format").displayName("Compression Format").description("Compression type to use when writing Avro files. Default is None.").allowableValues((Enum[])CodecType.values()).defaultValue(CodecType.NONE.toString()).required(true).build();
    private final Map<String, Schema> compiledAvroSchemaCache = new LinkedHashMap<String, Schema>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Schema> eldest) {
            return this.size() >= 20;
        }
    };
    static final AllowableValue AVRO_EMBEDDED = new AllowableValue("avro-embedded", "Embed Avro Schema", "The FlowFile will have the Avro schema embedded into the content, as is typical with Avro");

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema recordSchema, OutputStream out) throws IOException {
        String strategyValue = this.getConfigurationContext().getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        String compressionFormat = this.getConfigurationContext().getProperty(COMPRESSION_FORMAT).getValue();
        try {
            Schema avroSchema;
            try {
                Optional textOption;
                avroSchema = recordSchema.getSchemaFormat().isPresent() && ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? this.compileAvroSchema((String)textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
            }
            catch (Exception e) {
                throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
            }
            if (AVRO_EMBEDDED.getValue().equals(strategyValue)) {
                return new WriteAvroResultWithSchema(avroSchema, out, this.getCodecFactory(compressionFormat));
            }
            return new WriteAvroResultWithExternalSchema(avroSchema, recordSchema, this.getSchemaAccessWriter(recordSchema), out);
        }
        catch (SchemaNotFoundException e) {
            throw new ProcessException("Could not determine the Avro Schema to use for writing the content", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema compileAvroSchema(String text) {
        Schema compiled;
        AvroRecordSetWriter avroRecordSetWriter = this;
        synchronized (avroRecordSetWriter) {
            compiled = this.compiledAvroSchemaCache.get(text);
        }
        if (compiled != null) {
            return compiled;
        }
        Schema newlyCompiled = new Schema.Parser().parse(text);
        AvroRecordSetWriter avroRecordSetWriter2 = this;
        synchronized (avroRecordSetWriter2) {
            return this.compiledAvroSchemaCache.computeIfAbsent(text, t -> newlyCompiled);
        }
    }

    private CodecFactory getCodecFactory(String property) {
        CodecType type = CodecType.valueOf(property);
        switch (type) {
            case BZIP2: {
                return CodecFactory.bzip2Codec();
            }
            case DEFLATE: {
                return CodecFactory.deflateCodec((int)-1);
            }
            case LZO: {
                return CodecFactory.xzCodec((int)6);
            }
            case SNAPPY: {
                return CodecFactory.snappyCodec();
            }
        }
        return CodecFactory.nullCodec();
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(COMPRESSION_FORMAT);
        return properties;
    }

    @Override
    protected List<AllowableValue> getSchemaWriteStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(AVRO_EMBEDDED);
        allowableValues.addAll(super.getSchemaWriteStrategyValues());
        return allowableValues;
    }

    @Override
    protected AllowableValue getDefaultSchemaWriteStrategy() {
        return AVRO_EMBEDDED;
    }

    @Override
    protected Set<SchemaField> getRequiredSchemaFields(ValidationContext validationContext) {
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        if (writeStrategyValue.equalsIgnoreCase(AVRO_EMBEDDED.getValue())) {
            return requiredSchemaFields;
        }
        return super.getRequiredSchemaFields(validationContext);
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        String compressionFormatValue = validationContext.getProperty(COMPRESSION_FORMAT).getValue();
        if (!writeStrategyValue.equalsIgnoreCase(AVRO_EMBEDDED.getValue()) && !CodecType.NONE.toString().equals(compressionFormatValue)) {
            results.add(new ValidationResult.Builder().subject(COMPRESSION_FORMAT.getName()).valid(false).explanation("Avro compression codecs are stored in the header of the Avro file and therefore requires the header to be embedded into the content.").build());
        }
        return results;
    }

    private static enum CodecType {
        BZIP2,
        DEFLATE,
        NONE,
        SNAPPY,
        LZO;

    }
}

