/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class CSVRecordReader
implements RecordReader {
    private final CSVParser csvParser;
    private final RecordSchema schema;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;
    private List<String> rawFieldNames;

    public CSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat) throws IOException {
        CSVFormat withHeader;
        this.schema = schema;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(in));
        if (hasHeader) {
            withHeader = csvFormat.withSkipHeaderRecord();
            if (ignoreHeader) {
                withHeader = withHeader.withHeader(schema.getFieldNames().toArray(new String[0]));
            }
        } else {
            withHeader = csvFormat.withHeader(schema.getFieldNames().toArray(new String[0]));
        }
        this.csvParser = new CSVParser((Reader)reader, withHeader);
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        RecordSchema schema = this.getSchema();
        List<String> rawFieldNames = this.getRawFieldNames();
        int numFieldNames = rawFieldNames.size();
        Iterator iterator = this.csvParser.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (int i = 0; i < csvRecord.size(); ++i) {
                String rawFieldName = numFieldNames <= i ? "unknown_field_index_" + i : rawFieldNames.get(i);
                String rawValue = csvRecord.get(i);
                Optional dataTypeOption = schema.getDataType(rawFieldName);
                if (!dataTypeOption.isPresent() && dropUnknownFields) continue;
                Object value = coerceTypes && dataTypeOption.isPresent() ? this.convert(rawValue, (DataType)dataTypeOption.get(), rawFieldName) : (dataTypeOption.isPresent() ? this.convertSimpleIfPossible(rawValue, (DataType)dataTypeOption.get(), rawFieldName) : rawValue);
                values.put(rawFieldName, (String)value);
            }
            return new MapRecord(schema, values, coerceTypes, dropUnknownFields);
        }
        return null;
    }

    private List<String> getRawFieldNames() {
        if (this.rawFieldNames != null) {
            return this.rawFieldNames;
        }
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry entry : this.csvParser.getHeaderMap().entrySet()) {
            sortedMap.put(entry.getValue(), entry.getKey());
        }
        this.rawFieldNames = new ArrayList(sortedMap.values());
        return this.rawFieldNames;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    protected Object convert(String value, DataType dataType, String fieldName) {
        String trimmed;
        if (dataType == null || value == null) {
            return value;
        }
        String string = trimmed = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        if (trimmed.isEmpty()) {
            return null;
        }
        return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
    }

    private Object convertSimpleIfPossible(String value, DataType dataType, String fieldName) {
        String trimmed;
        if (dataType == null || value == null) {
            return value;
        }
        String string = trimmed = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        if (trimmed.isEmpty()) {
            return null;
        }
        switch (dataType.getFieldType()) {
            case STRING: {
                return value;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case TIME: 
            case TIMESTAMP: 
            case DATE: {
                if (DataTypeUtils.isCompatibleDataType((Object)trimmed, (DataType)dataType)) {
                    return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
                }
                return value;
            }
        }
        return value;
    }

    public void close() throws IOException {
        this.csvParser.close();
    }
}

