/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.csv.CSVUtils;

public class CSVValidators {
    public static final Validator UNESCAPED_SINGLE_CHAR_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input == null) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Input is null for this property").build();
            }
            String unescapeString = this.unescapeString(input);
            return new ValidationResult.Builder().subject(subject).input(unescapeString).explanation("Only non-null single characters are supported").valid(unescapeString.length() == 1 && unescapeString.charAt(0) != '\u0000' || context.isExpressionLanguagePresent(input)).build();
        }

        private String unescapeString(String input) {
            if (input != null && input.length() > 1) {
                input = StringEscapeUtils.unescapeJava((String)input);
            }
            return input;
        }
    };

    public static class SingleCharacterValidator
    implements Validator {
        private static final Set<String> illegalChars = new HashSet<String>();

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (input == null) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Input is null for this property").build();
            }
            String unescaped = CSVUtils.unescape(input);
            if (unescaped.length() != 1) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Value must be exactly 1 character but was " + input.length() + " in length").build();
            }
            if (illegalChars.contains(unescaped)) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(input + " is not a valid character for this property").build();
            }
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
        }

        static {
            illegalChars.add("\r");
            illegalChars.add("\n");
        }
    }
}

