/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RawRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;

public class WriteCSVResult
extends AbstractRecordSetWriter
implements RecordSetWriter,
RawRecordWriter {
    private final RecordSchema recordSchema;
    private final SchemaAccessWriter schemaWriter;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;
    private final CSVPrinter printer;
    private final Object[] fieldValues;
    private final boolean includeHeaderLine;
    private boolean headerWritten = false;
    private String[] fieldNames;

    public WriteCSVResult(CSVFormat csvFormat, RecordSchema recordSchema, SchemaAccessWriter schemaWriter, OutputStream out, String dateFormat, String timeFormat, String timestampFormat, boolean includeHeaderLine) throws IOException {
        super(out);
        this.recordSchema = recordSchema;
        this.schemaWriter = schemaWriter;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.timestampFormat = timestampFormat;
        this.includeHeaderLine = includeHeaderLine;
        CSVFormat formatWithHeader = csvFormat.withSkipHeaderRecord(true);
        OutputStreamWriter streamWriter = new OutputStreamWriter(out);
        this.printer = new CSVPrinter((Appendable)streamWriter, formatWithHeader);
        this.fieldValues = new Object[recordSchema.getFieldCount()];
    }

    private String getFormat(RecordField field) {
        DataType dataType = field.getDataType();
        switch (dataType.getFieldType()) {
            case DATE: {
                return this.dateFormat;
            }
            case TIME: {
                return this.timeFormat;
            }
            case TIMESTAMP: {
                return this.timestampFormat;
            }
        }
        return dataType.getFormat();
    }

    protected void onBeginRecordSet() throws IOException {
        this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    public void close() throws IOException {
        this.printer.close();
    }

    public void flush() throws IOException {
        this.printer.flush();
    }

    private String[] getFieldNames(Record record) {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        LinkedHashSet allFields = new LinkedHashSet();
        allFields.addAll(record.getRawFieldNames());
        allFields.addAll(this.recordSchema.getFieldNames());
        this.fieldNames = allFields.toArray(new String[0]);
        return this.fieldNames;
    }

    private void includeHeaderIfNecessary(Record record, boolean includeOnlySchemaFields) throws IOException {
        if (this.headerWritten || !this.includeHeaderLine) {
            return;
        }
        Object[] fieldNames = includeOnlySchemaFields ? this.recordSchema.getFieldNames().toArray(new Object[0]) : this.getFieldNames(record);
        this.printer.printRecord(fieldNames);
        this.headerWritten = true;
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.includeHeaderIfNecessary(record, true);
        int i = 0;
        for (RecordField recordField : this.recordSchema.getFields()) {
            this.fieldValues[i++] = record.getAsString(recordField, this.getFormat(recordField));
        }
        this.printer.printRecord(this.fieldValues);
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    public WriteResult writeRawRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.includeHeaderIfNecessary(record, false);
        String[] fieldNames = this.getFieldNames(record);
        Object[] recordFieldValues = fieldNames.length == this.fieldValues.length ? this.fieldValues : new String[fieldNames.length];
        int i = 0;
        for (String fieldName : fieldNames) {
            Optional recordField = this.recordSchema.getField(fieldName);
            recordFieldValues[i++] = recordField.isPresent() ? record.getAsString(fieldName, this.getFormat((RecordField)recordField.get())) : record.getAsString(fieldName);
        }
        this.printer.printRecord(recordFieldValues);
        Map attributes = this.schemaWriter.getAttributes(this.recordSchema);
        return WriteResult.of((int)this.incrementRecordCount(), (Map)attributes);
    }

    public String getMimeType() {
        return "text/csv";
    }
}

