/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.grok;

import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class GrokRecordReader
implements RecordReader {
    private final BufferedReader reader;
    private final Grok grok;
    private final boolean append;
    private final RecordSchema schemaFromGrok;
    private RecordSchema schema;
    private String nextLine;
    static final String STACK_TRACE_COLUMN_NAME = "stackTrace";
    static final String RAW_MESSAGE_NAME = "_raw";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("^\\s*(?:(?:    |\\t)+at )|(?:(?:    |\\t)+\\[CIRCULAR REFERENCE\\:)|(?:Caused by\\: )|(?:Suppressed\\: )|(?:\\s+... \\d+ (?:more|common frames? omitted)$)");

    public GrokRecordReader(InputStream in, Grok grok, RecordSchema schema, RecordSchema schemaFromGrok, boolean append) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.grok = grok;
        this.schema = schema;
        this.append = append;
        this.schemaFromGrok = schemaFromGrok;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        Map valueMap = null;
        StringBuilder raw = new StringBuilder();
        while (valueMap == null || valueMap.isEmpty()) {
            String line = this.nextLine == null ? this.reader.readLine() : this.nextLine;
            raw.append(line);
            this.nextLine = null;
            if (line == null) {
                return null;
            }
            Match match = this.grok.match(line);
            match.captures();
            valueMap = match.toMap();
        }
        String stackTrace = null;
        StringBuilder trailingText = new StringBuilder();
        while ((this.nextLine = this.reader.readLine()) != null) {
            Match nextLineMatch = this.grok.match(this.nextLine);
            nextLineMatch.captures();
            Map nextValueMap = nextLineMatch.toMap();
            if (!nextValueMap.isEmpty()) break;
            if (this.isStartOfStackTrace(this.nextLine)) {
                stackTrace = this.readStackTrace(this.nextLine);
                raw.append("\n").append(stackTrace);
                break;
            }
            if (!this.append) continue;
            trailingText.append("\n").append(this.nextLine);
            raw.append("\n").append(this.nextLine);
        }
        Record record = this.createRecord(valueMap, trailingText, stackTrace, raw.toString(), coerceTypes, dropUnknownFields);
        return record;
    }

    private Record createRecord(Map<String, Object> valueMap, StringBuilder trailingText, String stackTrace, String raw, boolean coerceTypes, boolean dropUnknown) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            Object coercedValue;
            String[] normalizedValue;
            String fieldName = entry.getKey();
            Object rawValue = entry.getValue();
            if (rawValue instanceof List) {
                List list = (List)rawValue;
                String[] array = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Object rawObject = list.get(i);
                    array[i] = rawObject == null ? null : rawObject.toString();
                }
                normalizedValue = array;
            } else {
                normalizedValue = rawValue == null ? null : rawValue.toString();
            }
            Optional optionalRecordField = this.schema.getField(fieldName);
            if (coerceTypes && optionalRecordField.isPresent()) {
                RecordField field = (RecordField)optionalRecordField.get();
                DataType fieldType = field.getDataType();
                coercedValue = this.convert(fieldType, normalizedValue, fieldName);
            } else {
                coercedValue = normalizedValue;
            }
            converted.put(fieldName, coercedValue);
        }
        if (this.append && trailingText.length() > 0) {
            String lastPopulatedFieldName = null;
            List schemaFields = this.schemaFromGrok.getFields();
            block2: for (int i = schemaFields.size() - 1; i >= 0; --i) {
                RecordField field = (RecordField)schemaFields.get(i);
                Object value = converted.get(field.getFieldName());
                if (value != null) {
                    lastPopulatedFieldName = field.getFieldName();
                    break;
                }
                for (String alias : field.getAliases()) {
                    value = converted.get(alias);
                    if (value == null) continue;
                    lastPopulatedFieldName = alias;
                    continue block2;
                }
            }
            if (lastPopulatedFieldName != null) {
                Object value = converted.get(lastPopulatedFieldName);
                if (value == null) {
                    converted.put(lastPopulatedFieldName, trailingText.toString());
                } else if (value instanceof String) {
                    converted.put(lastPopulatedFieldName, (String)value + trailingText.toString());
                }
            }
        }
        converted.put(STACK_TRACE_COLUMN_NAME, stackTrace);
        converted.put(RAW_MESSAGE_NAME, raw);
        return new MapRecord(this.schema, converted);
    }

    private boolean isStartOfStackTrace(String line) {
        if (line == null) {
            return false;
        }
        int index = line.indexOf("Exception: ");
        if (index < 0) {
            index = line.indexOf("Error: ");
        }
        if (index < 0) {
            return false;
        }
        return line.indexOf(" ") >= index;
    }

    private String readStackTrace(String firstLine) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder(firstLine);
        while ((line = this.reader.readLine()) != null) {
            if (this.isLineInStackTrace(line)) {
                sb.append("\n").append(line);
                continue;
            }
            this.nextLine = line;
            break;
        }
        return sb.toString();
    }

    private boolean isLineInStackTrace(String line) {
        return STACK_TRACE_PATTERN.matcher(line).find();
    }

    protected Object convert(DataType fieldType, Object rawValue, String fieldName) {
        boolean fieldEmpty;
        if (fieldType == null) {
            return rawValue;
        }
        if (rawValue == null) {
            return null;
        }
        boolean bl = fieldEmpty = rawValue instanceof String && ((String)rawValue).isEmpty();
        if (fieldEmpty && fieldType.getFieldType() != RecordFieldType.STRING) {
            return null;
        }
        return DataTypeUtils.convertType((Object)rawValue, (DataType)fieldType, (String)fieldName);
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

