/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.json.NullSuppression;
import org.apache.nifi.json.WriteJsonResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.DateTimeTextRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"json", "resultset", "writer", "serialize", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the results of a RecordSet as a JSON Array. Even if the RecordSet consists of a single row, it will be written as an array with a single element.")
public class JsonRecordSetWriter
extends DateTimeTextRecordSetWriter
implements RecordSetWriterFactory {
    static final AllowableValue ALWAYS_SUPPRESS = new AllowableValue("always-suppress", "Always Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null, will not be written out");
    static final AllowableValue NEVER_SUPPRESS = new AllowableValue("never-suppress", "Never Suppress", "Fields that are missing (present in the schema but not in the record), or that have a value of null, will be written out as a null value");
    static final AllowableValue SUPPRESS_MISSING = new AllowableValue("suppress-missing", "Suppress Missing Values", "When a field has a value of null, it will be written out. However, if a field is defined in the schema and not present in the record, the field will not be written out.");
    static final PropertyDescriptor SUPPRESS_NULLS = new PropertyDescriptor.Builder().name("suppress-nulls").displayName("Suppress Null Values").description("Specifies how the writer should handle a null field").allowableValues(new AllowableValue[]{NEVER_SUPPRESS, ALWAYS_SUPPRESS, SUPPRESS_MISSING}).defaultValue(NEVER_SUPPRESS.getValue()).required(true).build();
    static final PropertyDescriptor PRETTY_PRINT_JSON = new PropertyDescriptor.Builder().name("Pretty Print JSON").description("Specifies whether or not the JSON should be pretty printed").expressionLanguageSupported(false).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    private volatile boolean prettyPrint;
    private volatile NullSuppression nullSuppression;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(PRETTY_PRINT_JSON);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.prettyPrint = context.getProperty(PRETTY_PRINT_JSON).asBoolean();
        String suppressNullValue = context.getProperty(SUPPRESS_NULLS).getValue();
        NullSuppression suppression = ALWAYS_SUPPRESS.getValue().equals(suppressNullValue) ? NullSuppression.ALWAYS_SUPPRESS : (SUPPRESS_MISSING.getValue().equals(suppressNullValue) ? NullSuppression.SUPPRESS_MISSING : NullSuppression.NEVER_SUPPRESS);
        this.nullSuppression = suppression;
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out) throws SchemaNotFoundException, IOException {
        return new WriteJsonResult(logger, schema, this.getSchemaAccessWriter(schema), out, this.prettyPrint, this.nullSuppression, this.getDateFormat().orElse(null), this.getTimeFormat().orElse(null), this.getTimestampFormat().orElse(null));
    }
}

