/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.nifi.avro.AvroRecordReader;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.record.RecordSchema;

public class AvroReaderWithExplicitSchema
extends AvroRecordReader {
    private final InputStream in;
    private final RecordSchema recordSchema;
    private final DatumReader<GenericRecord> datumReader;
    private final BinaryDecoder decoder;
    private GenericRecord genericRecord;

    public AvroReaderWithExplicitSchema(InputStream in, RecordSchema recordSchema, Schema avroSchema) throws IOException, SchemaNotFoundException {
        this.in = in;
        this.recordSchema = recordSchema;
        this.datumReader = new GenericDatumReader(avroSchema);
        this.decoder = DecoderFactory.get().binaryDecoder(in, null);
    }

    public void close() throws IOException {
        this.in.close();
    }

    @Override
    protected GenericRecord nextAvroRecord() throws IOException {
        if (this.decoder.isEnd()) {
            return null;
        }
        try {
            this.genericRecord = (GenericRecord)this.datumReader.read((Object)this.genericRecord, (Decoder)this.decoder);
        }
        catch (EOFException eof) {
            return null;
        }
        return this.genericRecord;
    }

    public RecordSchema getSchema() throws MalformedRecordException {
        return this.recordSchema;
    }
}

