/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;

public abstract class AbstractJsonRowRecordReader
implements RecordReader {
    private final ComponentLog logger;
    private final JsonParser jsonParser;
    private final boolean array;
    private final JsonNode firstJsonNode;
    private boolean firstObjectConsumed = false;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper codec = new ObjectMapper();

    public AbstractJsonRowRecordReader(InputStream in, ComponentLog logger) throws IOException, MalformedRecordException {
        this.logger = logger;
        try {
            this.jsonParser = jsonFactory.createJsonParser(in);
            this.jsonParser.setCodec((ObjectCodec)codec);
            JsonToken token = this.jsonParser.nextToken();
            if (token == JsonToken.START_ARRAY) {
                this.array = true;
                token = this.jsonParser.nextToken();
            } else {
                this.array = false;
            }
            this.firstJsonNode = token == JsonToken.START_OBJECT ? this.jsonParser.readValueAsTree() : null;
        }
        catch (JsonParseException e) {
            throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
        }
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        if (this.firstObjectConsumed && !this.array) {
            return null;
        }
        JsonNode nextNode = this.getNextJsonNode();
        RecordSchema schema = this.getSchema();
        try {
            return this.convertJsonNodeToRecord(nextNode, schema, coerceTypes, dropUnknownFields);
        }
        catch (MalformedRecordException mre) {
            throw mre;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            this.logger.debug("Failed to convert JSON Element {} into a Record object using schema {} due to {}", new Object[]{nextNode, schema, e.toString(), e});
            throw new MalformedRecordException("Successfully parsed a JSON object from input but failed to convert into a Record object with the given schema", (Throwable)e);
        }
    }

    protected Object getRawNodeValue(JsonNode fieldNode) throws IOException {
        return this.getRawNodeValue(fieldNode, null);
    }

    protected Object getRawNodeValue(JsonNode fieldNode, DataType dataType) throws IOException {
        if (fieldNode == null || fieldNode.isNull()) {
            return null;
        }
        if (fieldNode.isNumber()) {
            return fieldNode.getNumberValue();
        }
        if (fieldNode.isBinary()) {
            return fieldNode.getBinaryValue();
        }
        if (fieldNode.isBoolean()) {
            return fieldNode.getBooleanValue();
        }
        if (fieldNode.isTextual()) {
            return fieldNode.getTextValue();
        }
        if (fieldNode.isArray()) {
            DataType elementDataType;
            ArrayNode arrayNode = (ArrayNode)fieldNode;
            int numElements = arrayNode.size();
            Object[] arrayElements = new Object[numElements];
            int count = 0;
            if (dataType != null && dataType.getFieldType() == RecordFieldType.ARRAY) {
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                elementDataType = arrayDataType.getElementType();
            } else {
                elementDataType = null;
            }
            for (JsonNode node : arrayNode) {
                Object value = this.getRawNodeValue(node, elementDataType);
                arrayElements[count++] = value;
            }
            return arrayElements;
        }
        if (fieldNode.isObject()) {
            SimpleRecordSchema childSchema;
            if (dataType != null && RecordFieldType.RECORD == dataType.getFieldType()) {
                RecordDataType recordDataType = (RecordDataType)dataType;
                childSchema = recordDataType.getChildSchema();
            } else {
                childSchema = null;
            }
            if (childSchema == null) {
                childSchema = new SimpleRecordSchema(Collections.emptyList());
            }
            Iterator fieldNames = fieldNode.getFieldNames();
            HashMap<String, Object> childValues = new HashMap<String, Object>();
            while (fieldNames.hasNext()) {
                String childFieldName = (String)fieldNames.next();
                Object childValue = this.getRawNodeValue(fieldNode.get(childFieldName), dataType);
                childValues.put(childFieldName, childValue);
            }
            MapRecord record = new MapRecord((RecordSchema)childSchema, childValues);
            return record;
        }
        return null;
    }

    private JsonNode getNextJsonNode() throws JsonParseException, IOException, MalformedRecordException {
        JsonToken token;
        if (!this.firstObjectConsumed) {
            this.firstObjectConsumed = true;
            return this.firstJsonNode;
        }
        block5: while (true) {
            if ((token = this.jsonParser.nextToken()) == null) {
                return null;
            }
            switch (token) {
                case END_OBJECT: {
                    continue block5;
                }
                case START_OBJECT: {
                    return this.jsonParser.readValueAsTree();
                }
                case END_ARRAY: 
                case START_ARRAY: {
                    return null;
                }
            }
            break;
        }
        throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
    }

    public void close() throws IOException {
        this.jsonParser.close();
    }

    protected JsonParser getJsonParser() {
        return this.jsonParser;
    }

    protected JsonFactory getJsonFactory() {
        return jsonFactory;
    }

    protected Optional<JsonNode> getFirstJsonNode() {
        return Optional.ofNullable(this.firstJsonNode);
    }

    protected abstract Record convertJsonNodeToRecord(JsonNode var1, RecordSchema var2, boolean var3, boolean var4) throws IOException, MalformedRecordException;
}

