/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;

public class JsonTreeRowRecordReader
extends AbstractJsonRowRecordReader {
    private final RecordSchema schema;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public JsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, String dateFormat, String timeFormat, String timestampFormat) throws IOException, MalformedRecordException {
        super(in, logger);
        this.schema = schema;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
    }

    @Override
    protected Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        return this.convertJsonNodeToRecord(jsonNode, schema, coerceTypes, dropUnknownFields, null);
    }

    private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, boolean coerceTypes, boolean dropUnknown, String fieldNamePrefix) throws IOException, MalformedRecordException {
        if (jsonNode == null) {
            return null;
        }
        return this.convertJsonNodeToRecord(jsonNode, schema, fieldNamePrefix, coerceTypes, dropUnknown);
    }

    private JsonNode getChildNode(JsonNode jsonNode, RecordField field) {
        if (jsonNode.has(field.getFieldName())) {
            return jsonNode.get(field.getFieldName());
        }
        for (String alias : field.getAliases()) {
            if (!jsonNode.has(alias)) continue;
            return jsonNode.get(alias);
        }
        return null;
    }

    private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, String fieldNamePrefix, boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
        HashMap<String, Object> values = new HashMap<String, Object>(schema.getFieldCount() * 2);
        if (dropUnknown) {
            for (RecordField recordField : schema.getFields()) {
                Object value;
                JsonNode childNode = this.getChildNode(jsonNode, recordField);
                if (childNode == null) continue;
                String fieldName = recordField.getFieldName();
                if (coerceTypes) {
                    DataType desiredType = recordField.getDataType();
                    String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                    value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                } else {
                    value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                }
                values.put(fieldName, value);
            }
        } else {
            Iterator fieldNames = jsonNode.getFieldNames();
            while (fieldNames.hasNext()) {
                Object value;
                String fieldName = (String)fieldNames.next();
                JsonNode childNode = jsonNode.get(fieldName);
                RecordField recordField = schema.getField(fieldName).orElse(null);
                if (coerceTypes && recordField != null) {
                    DataType desiredType = recordField.getDataType();
                    String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                    value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                } else {
                    value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType());
                }
                values.put(fieldName, value);
            }
        }
        Supplier<String> supplier = () -> jsonNode.toString();
        return new MapRecord(schema, values, SerializedForm.of(supplier, (String)"application/json"), false, dropUnknown);
    }

    protected Object convertField(JsonNode fieldNode, String fieldName, DataType desiredType, boolean dropUnknown) throws IOException, MalformedRecordException {
        if (fieldNode == null || fieldNode.isNull()) {
            return null;
        }
        switch (desiredType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Object rawValue = this.getRawNodeValue(fieldNode);
                Object converted = DataTypeUtils.convertType((Object)rawValue, (DataType)desiredType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
                return converted;
            }
            case MAP: {
                DataType valueType = ((MapDataType)desiredType).getValueType();
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator fieldNameItr = fieldNode.getFieldNames();
                while (fieldNameItr.hasNext()) {
                    String childName = (String)fieldNameItr.next();
                    JsonNode childNode = fieldNode.get(childName);
                    Object childValue = this.convertField(childNode, fieldName, valueType, dropUnknown);
                    map.put(childName, childValue);
                }
                return map;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)fieldNode;
                int numElements = arrayNode.size();
                Object[] arrayElements = new Object[numElements];
                int count = 0;
                for (JsonNode node : arrayNode) {
                    DataType elementType = ((ArrayDataType)desiredType).getElementType();
                    Object converted = this.convertField(node, fieldName, elementType, dropUnknown);
                    arrayElements[count++] = converted;
                }
                return arrayElements;
            }
            case RECORD: {
                if (fieldNode.isObject()) {
                    if (!(desiredType instanceof RecordDataType)) {
                        return null;
                    }
                    RecordSchema childSchema = ((RecordDataType)desiredType).getChildSchema();
                    if (childSchema == null) {
                        ArrayList<RecordField> fields = new ArrayList<RecordField>();
                        Iterator fieldNameItr = fieldNode.getFieldNames();
                        while (fieldNameItr.hasNext()) {
                            fields.add(new RecordField((String)fieldNameItr.next(), RecordFieldType.STRING.getDataType()));
                        }
                        childSchema = new SimpleRecordSchema(fields);
                    }
                    return this.convertJsonNodeToRecord(fieldNode, childSchema, fieldName + ".", true, dropUnknown);
                }
                return null;
            }
            case CHOICE: {
                return DataTypeUtils.convertType((Object)this.getRawNodeValue(fieldNode), (DataType)desiredType, (String)fieldName);
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

