/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.text;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.InheritSchemaFromRecord;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.text.FreeFormTextWriter;

@Tags(value={"text", "freeform", "expression", "language", "el", "record", "recordset", "resultset", "writer", "serialize"})
@CapabilityDescription(value="Writes the contents of a RecordSet as free-form text. The configured text is able to make use of the Expression Language to reference each of the fields that are available in a Record. Each record in the RecordSet will be separated by a single newline character.")
public class FreeFormTextRecordSetWriter
extends SchemaRegistryRecordSetWriter
implements RecordSetWriterFactory {
    static final PropertyDescriptor TEXT = new PropertyDescriptor.Builder().name("Text").description("The text to use when writing the results. This property will evaluate the Expression Language using any of the fields available in a Record.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).required(true).build();
    static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character set to use when writing the data to the FlowFile").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").expressionLanguageSupported(false).required(true).build();
    private volatile PropertyValue textValue;
    private volatile Charset characterSet;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(TEXT);
        properties.add(CHARACTER_SET);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.textValue = context.getProperty(TEXT);
        this.characterSet = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out) {
        return new FreeFormTextWriter(this.textValue, this.characterSet, out);
    }

    @Override
    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, ConfigurationContext context) {
        return new InheritSchemaFromRecord();
    }
}

