/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.nifi.json.NullSuppression;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RawRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

public class WriteJsonResult
extends AbstractRecordSetWriter
implements RecordSetWriter,
RawRecordWriter {
    private final ComponentLog logger;
    private final SchemaAccessWriter schemaAccess;
    private final RecordSchema recordSchema;
    private final JsonFactory factory = new JsonFactory();
    private final JsonGenerator generator;
    private final NullSuppression nullSuppression;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public WriteJsonResult(ComponentLog logger, RecordSchema recordSchema, SchemaAccessWriter schemaAccess, OutputStream out, boolean prettyPrint, NullSuppression nullSuppression, String dateFormat, String timeFormat, String timestampFormat) throws IOException {
        super(out);
        this.logger = logger;
        this.recordSchema = recordSchema;
        this.schemaAccess = schemaAccess;
        this.nullSuppression = nullSuppression;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        this.generator = this.factory.createJsonGenerator(out);
        if (prettyPrint) {
            this.generator.useDefaultPrettyPrinter();
        }
    }

    protected void onBeginRecordSet() throws IOException {
        OutputStream out = this.getOutputStream();
        this.schemaAccess.writeHeader(this.recordSchema, out);
        this.generator.writeStartArray();
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        this.generator.writeEndArray();
        return this.schemaAccess.getAttributes(this.recordSchema);
    }

    public void close() throws IOException {
        if (this.generator != null) {
            this.generator.close();
        }
        super.close();
    }

    public void flush() throws IOException {
        if (this.generator != null) {
            this.generator.flush();
        }
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.generator.flush();
            this.schemaAccess.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.writeRecord(record, this.recordSchema, this.generator, g -> g.writeStartObject(), g -> g.writeEndObject(), true);
        return this.schemaAccess.getAttributes(this.recordSchema);
    }

    public WriteResult writeRawRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.generator.flush();
            this.schemaAccess.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.writeRecord(record, this.recordSchema, this.generator, g -> g.writeStartObject(), g -> g.writeEndObject(), false);
        Map attributes = this.schemaAccess.getAttributes(this.recordSchema);
        return WriteResult.of((int)this.incrementRecordCount(), (Map)attributes);
    }

    private void writeRecord(Record record, RecordSchema writeSchema, JsonGenerator generator, GeneratorTask startTask, GeneratorTask endTask, boolean schemaAware) throws JsonGenerationException, IOException {
        Object serialized;
        Object form;
        Optional serializedForm = record.getSerializedForm();
        if (serializedForm.isPresent() && (form = (SerializedForm)serializedForm.get()).getMimeType().equals(this.getMimeType()) && record.getSchema().equals(writeSchema) && (serialized = form.getSerialized()) instanceof String) {
            generator.writeRawValue((String)serialized);
            return;
        }
        try {
            startTask.apply(generator);
            if (schemaAware) {
                for (RecordField field : writeSchema.getFields()) {
                    String fieldName = field.getFieldName();
                    Object value = record.getValue(field);
                    if (value == null) {
                        if (this.nullSuppression != NullSuppression.NEVER_SUPPRESS && (this.nullSuppression != NullSuppression.SUPPRESS_MISSING || !this.isFieldPresent(field, record))) continue;
                        generator.writeNullField(fieldName);
                        continue;
                    }
                    generator.writeFieldName(fieldName);
                    DataType dataType = (DataType)writeSchema.getDataType(fieldName).get();
                    this.writeValue(generator, value, fieldName, dataType);
                }
            } else {
                for (String fieldName : record.getRawFieldNames()) {
                    Object value = record.getValue(fieldName);
                    if (value == null) {
                        if (this.nullSuppression != NullSuppression.NEVER_SUPPRESS && (this.nullSuppression != NullSuppression.SUPPRESS_MISSING || !record.getRawFieldNames().contains(fieldName))) continue;
                        generator.writeNullField(fieldName);
                        continue;
                    }
                    generator.writeFieldName(fieldName);
                    this.writeRawValue(generator, value, fieldName);
                }
            }
            endTask.apply(generator);
        }
        catch (Exception e) {
            this.logger.error("Failed to write {} with schema {} as a JSON Object due to {}", new Object[]{record, record.getSchema(), e.toString(), e});
            throw e;
        }
    }

    private boolean isFieldPresent(RecordField field, Record record) {
        Set rawFieldNames = record.getRawFieldNames();
        if (rawFieldNames.contains(field.getFieldName())) {
            return true;
        }
        for (String alias : field.getAliases()) {
            if (!rawFieldNames.contains(alias)) continue;
            return true;
        }
        return false;
    }

    private void writeRawValue(JsonGenerator generator, Object value, String fieldName) throws JsonGenerationException, IOException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        if (value instanceof Record) {
            Record record = (Record)value;
            this.writeRecord(record, record.getSchema(), generator, gen -> gen.writeStartObject(), gen -> gen.writeEndObject(), false);
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            generator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                String mapKey = (String)entry.getKey();
                Object mapValue = entry.getValue();
                generator.writeFieldName(mapKey);
                this.writeRawValue(generator, mapValue, fieldName + "." + mapKey);
            }
            generator.writeEndObject();
            return;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            generator.writeStartArray();
            for (Object element : values) {
                this.writeRawValue(generator, element, fieldName);
            }
            generator.writeEndArray();
            return;
        }
        generator.writeObject(value);
    }

    private void writeValue(JsonGenerator generator, Object value, String fieldName, DataType dataType) throws JsonGenerationException, IOException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        DataType chosenDataType = dataType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType((Object)value, (ChoiceDataType)((ChoiceDataType)dataType)) : dataType;
        Object coercedValue = DataTypeUtils.convertType((Object)value, (DataType)chosenDataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
        if (coercedValue == null) {
            generator.writeNull();
            return;
        }
        switch (chosenDataType.getFieldType()) {
            case DATE: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_DATE_FORMAT);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case TIME: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_TIME_FORMAT);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case TIMESTAMP: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_TIMESTAMP_FORMAT);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case DOUBLE: {
                generator.writeNumber(DataTypeUtils.toDouble((Object)coercedValue, (String)fieldName).doubleValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(DataTypeUtils.toFloat((Object)coercedValue, (String)fieldName).floatValue());
                break;
            }
            case LONG: {
                generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                break;
            }
            case INT: 
            case BYTE: 
            case SHORT: {
                generator.writeNumber(DataTypeUtils.toInteger((Object)coercedValue, (String)fieldName).intValue());
                break;
            }
            case CHAR: 
            case STRING: {
                generator.writeString(coercedValue.toString());
                break;
            }
            case BIGINT: {
                if (coercedValue instanceof Long) {
                    generator.writeNumber(((Long)coercedValue).longValue());
                    break;
                }
                generator.writeNumber((BigInteger)coercedValue);
                break;
            }
            case BOOLEAN: {
                String stringValue = coercedValue.toString();
                if ("true".equalsIgnoreCase(stringValue)) {
                    generator.writeBoolean(true);
                    break;
                }
                if ("false".equalsIgnoreCase(stringValue)) {
                    generator.writeBoolean(false);
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case RECORD: {
                Record record = (Record)coercedValue;
                RecordDataType recordDataType = (RecordDataType)chosenDataType;
                RecordSchema childSchema = recordDataType.getChildSchema();
                this.writeRecord(record, childSchema, generator, gen -> gen.writeStartObject(), gen -> gen.writeEndObject(), true);
                break;
            }
            case MAP: {
                MapDataType mapDataType = (MapDataType)chosenDataType;
                DataType valueDataType = mapDataType.getValueType();
                Map map = (Map)coercedValue;
                generator.writeStartObject();
                for (Map.Entry entry : map.entrySet()) {
                    String mapKey = (String)entry.getKey();
                    Object mapValue = entry.getValue();
                    generator.writeFieldName(mapKey);
                    this.writeValue(generator, mapValue, fieldName + "." + mapKey, valueDataType);
                }
                generator.writeEndObject();
                break;
            }
            default: {
                if (coercedValue instanceof Object[]) {
                    Object[] values = (Object[])coercedValue;
                    ArrayDataType arrayDataType = (ArrayDataType)dataType;
                    DataType elementType = arrayDataType.getElementType();
                    this.writeArray(values, fieldName, generator, elementType);
                    break;
                }
                generator.writeString(coercedValue.toString());
            }
        }
    }

    private void writeArray(Object[] values, String fieldName, JsonGenerator generator, DataType elementType) throws JsonGenerationException, IOException {
        generator.writeStartArray();
        for (int i = 0; i < values.length; ++i) {
            Object element = values[i];
            this.writeValue(generator, element, fieldName, elementType);
        }
        generator.writeEndArray();
    }

    public String getMimeType() {
        return "application/json";
    }

    private static interface GeneratorTask {
        public void apply(JsonGenerator var1) throws JsonGenerationException, IOException;
    }
}

