/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.csv.CSVHeaderSchemaStrategy;
import org.apache.nifi.csv.CSVRecordReader;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.csv.JacksonCSVRecordReader;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.stream.io.NonCloseableInputStream;

@Tags(value={"csv", "parse", "record", "row", "reader", "delimited", "comma", "separated", "values"})
@CapabilityDescription(value="Parses CSV-formatted data, returning each row in the CSV file as a separate record. This reader assumes that the first line in the content is the column names and all subsequent lines are the values. See Controller Service's Usage for further documentation.")
public class CSVReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private final AllowableValue headerDerivedAllowableValue = new AllowableValue("csv-header-derived", "Use String Fields From Header", "The first non-comment line of the CSV file is a header line that contains the names of the columns. The schema will be derived by using the column names in the header and assuming that all columns are of type String.");
    public static final AllowableValue APACHE_COMMONS_CSV = new AllowableValue("commons-csv", "Apache Commons CSV", "The CSV parser implementation from the Apache Commons CSV library.");
    public static final AllowableValue JACKSON_CSV = new AllowableValue("jackson-csv", "Jackson CSV", "The CSV parser implementation from the Jackson Dataformats library.");
    public static final PropertyDescriptor CSV_PARSER = new PropertyDescriptor.Builder().name("csv-reader-csv-parser").displayName("CSV Parser").description("Specifies which parser to use to read CSV records. NOTE: Different parsers may support different subsets of functionality and may also exhibit different levels of performance.").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{APACHE_COMMONS_CSV, JACKSON_CSV}).defaultValue(APACHE_COMMONS_CSV.getValue()).required(true).build();
    private volatile String csvParser;
    private volatile CSVFormat csvFormat;
    private volatile String dateFormat;
    private volatile String timeFormat;
    private volatile String timestampFormat;
    private volatile boolean firstLineIsHeader;
    private volatile boolean ignoreHeader;
    private volatile String charSet;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(CSV_PARSER);
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        properties.add(CSVUtils.CSV_FORMAT);
        properties.add(CSVUtils.VALUE_SEPARATOR);
        properties.add(CSVUtils.FIRST_LINE_IS_HEADER);
        properties.add(CSVUtils.IGNORE_CSV_HEADER);
        properties.add(CSVUtils.QUOTE_CHAR);
        properties.add(CSVUtils.ESCAPE_CHAR);
        properties.add(CSVUtils.COMMENT_MARKER);
        properties.add(CSVUtils.NULL_STRING);
        properties.add(CSVUtils.TRIM_FIELDS);
        properties.add(CSVUtils.CHARSET);
        return properties;
    }

    @OnEnabled
    public void storeCsvFormat(ConfigurationContext context) {
        this.csvParser = context.getProperty(CSV_PARSER).getValue();
        this.csvFormat = CSVUtils.createCSVFormat((PropertyContext)context);
        this.dateFormat = context.getProperty(DateTimeUtils.DATE_FORMAT).getValue();
        this.timeFormat = context.getProperty(DateTimeUtils.TIME_FORMAT).getValue();
        this.timestampFormat = context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue();
        this.firstLineIsHeader = context.getProperty(CSVUtils.FIRST_LINE_IS_HEADER).asBoolean();
        this.ignoreHeader = context.getProperty(CSVUtils.IGNORE_CSV_HEADER).asBoolean();
        this.charSet = context.getProperty(CSVUtils.CHARSET).getValue();
        String accessStrategy = context.getProperty(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).getValue();
        if (this.headerDerivedAllowableValue.getValue().equals(accessStrategy)) {
            this.csvFormat = this.csvFormat.withFirstRecordAsHeader();
            this.firstLineIsHeader = true;
        }
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws IOException, SchemaNotFoundException {
        BufferedInputStream bufferedIn = new BufferedInputStream(in);
        bufferedIn.mark(0x100000);
        RecordSchema schema = this.getSchema(variables, (InputStream)new NonCloseableInputStream((InputStream)bufferedIn), null);
        bufferedIn.reset();
        if (APACHE_COMMONS_CSV.getValue().equals(this.csvParser)) {
            return new CSVRecordReader(bufferedIn, logger, schema, this.csvFormat, this.firstLineIsHeader, this.ignoreHeader, this.dateFormat, this.timeFormat, this.timestampFormat, this.charSet);
        }
        if (JACKSON_CSV.getValue().equals(this.csvParser)) {
            return new JacksonCSVRecordReader(bufferedIn, logger, schema, this.csvFormat, this.firstLineIsHeader, this.ignoreHeader, this.dateFormat, this.timeFormat, this.timestampFormat, this.charSet);
        }
        throw new IOException("Parser not supported");
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, ConfigurationContext context) {
        if (strategy.equalsIgnoreCase(this.headerDerivedAllowableValue.getValue())) {
            return new CSVHeaderSchemaStrategy(context);
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String allowableValue, SchemaRegistry schemaRegistry, ValidationContext context) {
        if (allowableValue.equalsIgnoreCase(this.headerDerivedAllowableValue.getValue())) {
            return new CSVHeaderSchemaStrategy(context);
        }
        return super.getSchemaAccessStrategy(allowableValue, schemaRegistry, context);
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(this.headerDerivedAllowableValue);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return this.headerDerivedAllowableValue;
    }
}

