/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.grok;

import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.GrokUtils;
import io.krakens.grok.api.exception.GrokException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.grok.GrokExpressionValidator;
import org.apache.nifi.grok.GrokRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"grok", "logs", "logfiles", "parse", "unstructured", "text", "record", "reader", "regex", "pattern", "logstash"})
@CapabilityDescription(value="Provides a mechanism for reading unstructured text data, such as log files, and structuring the data so that it can be processed. The service is configured using Grok patterns. The service reads from a stream of data and splits each message that it finds into a separate Record, each containing the fields that are configured. If a line in the input does not match the expected message pattern, the line of text is either considered to be part of the previous message or is skipped, depending on the configuration, with the exception of stack traces. A stack trace that is found at the end of a log message is considered to be part of the previous message but is added to the 'stackTrace' field of the Record. If a record has no stack trace, it will have a NULL value for the stackTrace field (assuming that the schema does in fact include a stackTrace field of type String). Assuming that the schema includes a '_raw' field of type String, the raw message will be included in the Record.")
public class GrokReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private volatile GrokCompiler grokCompiler;
    private volatile Grok grok;
    private volatile boolean appendUnmatchedLine;
    private volatile RecordSchema recordSchema;
    private volatile RecordSchema recordSchemaFromGrok;
    static final String DEFAULT_PATTERN_NAME = "/default-grok-patterns.txt";
    static final AllowableValue APPEND_TO_PREVIOUS_MESSAGE = new AllowableValue("append-to-previous-message", "Append to Previous Message", "The line of text that does not match the Grok Expression will be appended to the last field of the prior message.");
    static final AllowableValue SKIP_LINE = new AllowableValue("skip-line", "Skip Line", "The line of text that does not match the Grok Expression will be skipped.");
    static final AllowableValue STRING_FIELDS_FROM_GROK_EXPRESSION = new AllowableValue("string-fields-from-grok-expression", "Use String Fields From Grok Expression", "The schema will be derived by using the field names present in the Grok Expression. All fields will be assumed to be of type String. Additionally, a field will be included with a name of 'stackTrace' and a type of String.");
    static final PropertyDescriptor PATTERN_FILE = new PropertyDescriptor.Builder().name("Grok Pattern File").description("Path to a file that contains Grok Patterns to use for parsing logs. If not specified, a built-in default Pattern file will be used. If specified, all patterns in the given pattern file will override the default patterns. See the Controller Service's Additional Details for a list of pre-defined patterns.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).build();
    static final PropertyDescriptor GROK_EXPRESSION = new PropertyDescriptor.Builder().name("Grok Expression").description("Specifies the format of a log line in Grok format. This allows the Record Reader to understand how to parse each log line. If a line in the log file does not match this pattern, the line will be assumed to belong to the previous log message.If other Grok expressions are referenced by this expression, they need to be supplied in the Grok Pattern File").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor NO_MATCH_BEHAVIOR = new PropertyDescriptor.Builder().name("no-match-behavior").displayName("No Match Behavior").description("If a line of text is encountered and it does not match the given Grok Expression, and it is not part of a stack trace, this property specifies how the text should be processed.").allowableValues(new AllowableValue[]{APPEND_TO_PREVIOUS_MESSAGE, SKIP_LINE}).defaultValue(APPEND_TO_PREVIOUS_MESSAGE.getValue()).required(true).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(PATTERN_FILE);
        properties.add(GROK_EXPRESSION);
        properties.add(NO_MATCH_BEHAVIOR);
        return properties;
    }

    @OnEnabled
    public void preCompile(ConfigurationContext context) throws GrokException, IOException {
        Throwable throwable;
        InputStreamReader reader;
        this.grokCompiler = GrokCompiler.newInstance();
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_PATTERN_NAME);){
            reader = new InputStreamReader(in);
            throwable = null;
            try {
                this.grokCompiler.register((Reader)reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
        }
        if (context.getProperty(PATTERN_FILE).isSet()) {
            in = new FileInputStream(context.getProperty(PATTERN_FILE).evaluateAttributeExpressions().getValue());
            var3_3 = null;
            try {
                reader = new InputStreamReader(in);
                throwable = null;
                try {
                    this.grokCompiler.register((Reader)reader);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var3_3 = throwable6;
                throw throwable6;
            }
            finally {
                if (in != null) {
                    if (var3_3 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable7) {
                            var3_3.addSuppressed(throwable7);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        this.grok = this.grokCompiler.compile(context.getProperty(GROK_EXPRESSION).getValue());
        this.appendUnmatchedLine = context.getProperty(NO_MATCH_BEHAVIOR).getValue().equalsIgnoreCase(APPEND_TO_PREVIOUS_MESSAGE.getValue());
        this.recordSchemaFromGrok = GrokReader.createRecordSchema(this.grok);
        String schemaAccess = context.getProperty(this.getSchemaAcessStrategyDescriptor()).getValue();
        this.recordSchema = STRING_FIELDS_FROM_GROK_EXPRESSION.getValue().equals(schemaAccess) ? this.recordSchemaFromGrok : null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        String subject = GROK_EXPRESSION.getName();
        String input = validationContext.getProperty(GROK_EXPRESSION).getValue();
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_PATTERN_NAME);
             InputStreamReader reader = new InputStreamReader(in);){
            grokCompiler.register((Reader)reader);
        }
        catch (IOException e) {
            results.add(new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Unable to load default patterns: " + e.getMessage()).build());
        }
        GrokExpressionValidator validator = new GrokExpressionValidator(validationContext.getProperty(PATTERN_FILE).getValue(), grokCompiler);
        results.add(validator.validate(subject, input, validationContext));
        return results;
    }

    static RecordSchema createRecordSchema(Grok grok) {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        String grokExpression = grok.getOriginalGrokPattern();
        GrokReader.populateSchemaFieldNames(grok, grokExpression, fields);
        fields.add(new RecordField("stackTrace", RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField("_raw", RecordFieldType.STRING.getDataType(), true));
        SimpleRecordSchema schema = new SimpleRecordSchema(fields);
        return schema;
    }

    private static void populateSchemaFieldNames(Grok grok, String grokExpression, List<RecordField> fields) {
        Matcher matcher;
        Set namedGroups = GrokUtils.getNameGroups((String)GrokUtils.GROK_PATTERN.pattern());
        while (grokExpression.length() > 0 && (matcher = GrokUtils.GROK_PATTERN.matcher(grokExpression)).find()) {
            Map extractedGroups = GrokUtils.namedGroups((Matcher)matcher, (Set)namedGroups);
            String subName = (String)extractedGroups.get("subname");
            if (subName == null) {
                String subPatternName = (String)extractedGroups.get("pattern");
                if (subPatternName == null) continue;
                String subExpression = (String)grok.getPatterns().get(subPatternName);
                GrokReader.populateSchemaFieldNames(grok, subExpression, fields);
            } else {
                DataType dataType = RecordFieldType.STRING.getDataType();
                RecordField recordField = new RecordField(subName, dataType);
                fields.add(recordField);
            }
            if (grokExpression.length() <= matcher.end() + 1) break;
            grokExpression = grokExpression.substring(matcher.end());
        }
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(STRING_FIELDS_FROM_GROK_EXPRESSION);
        allowableValues.addAll(super.getSchemaAccessStrategyValues());
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return STRING_FIELDS_FROM_GROK_EXPRESSION;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, ConfigurationContext context) {
        if (strategy.equalsIgnoreCase(STRING_FIELDS_FROM_GROK_EXPRESSION.getValue())) {
            return this.createAccessStrategy();
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, ValidationContext context) {
        if (strategy.equalsIgnoreCase(STRING_FIELDS_FROM_GROK_EXPRESSION.getValue())) {
            return this.createAccessStrategy();
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    private SchemaAccessStrategy createAccessStrategy() {
        return new SchemaAccessStrategy(){
            private final Set<SchemaField> schemaFields = EnumSet.noneOf(SchemaField.class);

            public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException {
                return GrokReader.this.recordSchema;
            }

            public Set<SchemaField> getSuppliedSchemaFields() {
                return this.schemaFields;
            }
        };
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws IOException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(variables, in, null);
        return new GrokRecordReader(in, this.grok, schema, this.recordSchemaFromGrok, this.appendUnmatchedLine);
    }
}

