/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.schema.inference.RecordSource;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonRecordSource
implements RecordSource<JsonNode> {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser jsonParser;

    public JsonRecordSource(InputStream in) throws IOException {
        this.jsonParser = jsonFactory.createJsonParser(in);
    }

    @Override
    public JsonNode next() throws IOException {
        JsonToken token;
        do {
            if ((token = this.jsonParser.nextToken()) != null) continue;
            return null;
        } while (token != JsonToken.START_OBJECT);
        return this.jsonParser.readValueAsTree();
    }

    static {
        jsonFactory.setCodec((ObjectCodec)new ObjectMapper());
    }
}

