/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.nifi.schema.inference.HierarchicalSchemaInference;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;

public class JsonSchemaInference
extends HierarchicalSchemaInference<JsonNode> {
    private final TimeValueInference timeValueInference;

    public JsonSchemaInference(TimeValueInference timeValueInference) {
        this.timeValueInference = timeValueInference;
    }

    @Override
    protected DataType getDataType(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            String text = jsonNode.getTextValue();
            if (text == null) {
                return RecordFieldType.STRING.getDataType();
            }
            Optional<DataType> timeDataType = this.timeValueInference.getDataType(text);
            return timeDataType.orElse(RecordFieldType.STRING.getDataType());
        }
        if (jsonNode.isObject()) {
            RecordSchema schema = this.createSchema(jsonNode);
            return RecordFieldType.RECORD.getRecordDataType(schema);
        }
        if (jsonNode.isIntegralNumber()) {
            return RecordFieldType.LONG.getDataType();
        }
        if (jsonNode.isFloatingPointNumber()) {
            return RecordFieldType.FLOAT.getDataType();
        }
        if (jsonNode.isDouble()) {
            return RecordFieldType.DOUBLE.getDataType();
        }
        if (jsonNode.isBinary()) {
            return RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType());
        }
        if (jsonNode.isBoolean()) {
            return RecordFieldType.BOOLEAN.getDataType();
        }
        return null;
    }

    @Override
    protected boolean isObject(JsonNode value) {
        return value.isObject();
    }

    @Override
    protected boolean isArray(JsonNode value) {
        return value.isArray();
    }

    @Override
    protected void forEachFieldInRecord(JsonNode rawRecord, BiConsumer<String, JsonNode> fieldConsumer) {
        Iterator itr = rawRecord.getFields();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String fieldName = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            fieldConsumer.accept(fieldName, value);
        }
    }

    @Override
    protected void forEachRawRecordInArray(JsonNode arrayRecord, Consumer<JsonNode> rawRecordConsumer) {
        ArrayNode arrayNode = (ArrayNode)arrayRecord;
        for (JsonNode element : arrayNode) {
            rawRecordConsumer.accept(element);
        }
    }

    @Override
    protected String getRootName(JsonNode rawRecord) {
        return null;
    }
}

