/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class FieldTypeInference {
    private static final DataType DEFAULT_DATA_TYPE = RecordFieldType.STRING.getDataType();
    private DataType singleDataType = null;
    private Set<DataType> possibleDataTypes;

    public void addPossibleDataType(DataType dataType) {
        if (dataType == null) {
            return;
        }
        if (this.singleDataType == null) {
            this.singleDataType = dataType;
            return;
        }
        if (this.possibleDataTypes == null && this.singleDataType.equals((Object)dataType)) {
            return;
        }
        RecordFieldType singleFieldType = this.singleDataType.getFieldType();
        RecordFieldType additionalFieldType = dataType.getFieldType();
        if (singleFieldType == RecordFieldType.RECORD && additionalFieldType == RecordFieldType.RECORD) {
            RecordSchema singleDataTypeSchema = ((RecordDataType)this.singleDataType).getChildSchema();
            RecordSchema newSchema = ((RecordDataType)dataType).getChildSchema();
            RecordSchema mergedSchema = DataTypeUtils.merge((RecordSchema)singleDataTypeSchema, (RecordSchema)newSchema);
            this.singleDataType = RecordFieldType.RECORD.getRecordDataType(mergedSchema);
            return;
        }
        if (singleFieldType.isWiderThan(additionalFieldType)) {
            return;
        }
        if (additionalFieldType.isWiderThan(singleFieldType)) {
            this.singleDataType = dataType;
            return;
        }
        if (this.possibleDataTypes == null) {
            this.possibleDataTypes = new HashSet<DataType>();
            this.possibleDataTypes.add(this.singleDataType);
        }
        this.possibleDataTypes.add(dataType);
    }

    public DataType toDataType() {
        if (this.possibleDataTypes == null) {
            if (this.singleDataType == null) {
                return DEFAULT_DATA_TYPE;
            }
            return this.singleDataType;
        }
        DataType aggregate = null;
        for (DataType dataType : this.possibleDataTypes) {
            aggregate = DataTypeUtils.mergeDataTypes(aggregate, (DataType)dataType);
        }
        return aggregate;
    }
}

