/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.inference;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.xml.inference.XmlArrayNode;
import org.apache.nifi.xml.inference.XmlContainerNode;
import org.apache.nifi.xml.inference.XmlNode;
import org.apache.nifi.xml.inference.XmlNodeType;
import org.apache.nifi.xml.inference.XmlTextNode;

public class XmlRecordSource
implements RecordSource<XmlNode> {
    private final XMLEventReader xmlEventReader;

    public XmlRecordSource(InputStream in, boolean ignoreWrapper) throws IOException {
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.xmlEventReader = xmlInputFactory.createXMLEventReader(in);
            if (ignoreWrapper) {
                this.readStartElement();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not parse XML", e);
        }
    }

    @Override
    public XmlNode next() throws IOException {
        try {
            StartElement startElement = this.readStartElement();
            if (startElement == null) {
                return null;
            }
            XmlNode xmlNode = this.readNext(startElement);
            return xmlNode;
        }
        catch (XMLStreamException xmle) {
            throw new IOException(xmle);
        }
    }

    private XmlNode readNext(StartElement startElement) throws XMLStreamException, IOException {
        StringBuilder content = new StringBuilder();
        LinkedHashMap<String, XmlNode> childNodes = new LinkedHashMap<String, XmlNode>();
        while (this.xmlEventReader.hasNext()) {
            Characters characters;
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isEndDocument()) {
                throw new EOFException("Expected to encounter End-of-Element tag for start tag '" + startElement.getName() + "'");
            }
            if (xmlEvent.isEndElement()) break;
            if (xmlEvent.isCharacters() && !(characters = xmlEvent.asCharacters()).isWhiteSpace()) {
                content.append(characters.getData());
            }
            if (!xmlEvent.isStartElement()) continue;
            StartElement childStartElement = xmlEvent.asStartElement();
            XmlNode childNode = this.readNext(childStartElement);
            String childName = childStartElement.getName().getLocalPart();
            XmlNode existingNode = (XmlNode)childNodes.get(childName);
            if (existingNode == null) {
                childNodes.put(childName, childNode);
                continue;
            }
            if (existingNode.getNodeType() == XmlNodeType.ARRAY) {
                ((XmlArrayNode)existingNode).addElement(childNode);
                continue;
            }
            XmlArrayNode arrayNode = new XmlArrayNode(childStartElement.getName().getLocalPart());
            arrayNode.addElement(existingNode);
            arrayNode.addElement(childNode);
            childNodes.put(childName, arrayNode);
        }
        String nodeName = startElement.getName().getLocalPart();
        if (childNodes.isEmpty()) {
            return new XmlTextNode(nodeName, content.toString().trim());
        }
        return new XmlContainerNode(nodeName, childNodes);
    }

    private StartElement readStartElement() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            StartElement startElement = xmlEvent.asStartElement();
            return startElement;
        }
        return null;
    }
}

