/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class WriteAvroResultWithExternalSchema
extends AbstractRecordSetWriter {
    private final SchemaAccessWriter schemaAccessWriter;
    private final RecordSchema recordSchema;
    private final Schema avroSchema;
    private final BinaryEncoder encoder;
    private final OutputStream buffered;
    private final DatumWriter<GenericRecord> datumWriter;
    private final BlockingQueue<BinaryEncoder> recycleQueue;

    public WriteAvroResultWithExternalSchema(Schema avroSchema, RecordSchema recordSchema, SchemaAccessWriter schemaAccessWriter, OutputStream out, BlockingQueue<BinaryEncoder> recycleQueue, ComponentLog logger) {
        super(out);
        this.recordSchema = recordSchema;
        this.schemaAccessWriter = schemaAccessWriter;
        this.avroSchema = avroSchema;
        this.buffered = new BufferedOutputStream(out);
        this.recycleQueue = recycleQueue;
        BinaryEncoder reusableEncoder = (BinaryEncoder)recycleQueue.poll();
        if (reusableEncoder == null) {
            logger.debug("Was not able to obtain a BinaryEncoder from reuse pool. This is normal for the first X number of iterations (where X is equal to the max size of the pool), but if this continues, it indicates that increasing the size of the pool will likely yield better performance for this Avro Writer.");
        }
        this.encoder = EncoderFactory.get().blockingBinaryEncoder(this.buffered, reusableEncoder);
        this.datumWriter = new GenericDatumWriter(avroSchema);
    }

    protected void onBeginRecordSet() throws IOException {
        this.schemaAccessWriter.writeHeader(this.recordSchema, this.buffered);
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        this.flush();
        return this.schemaAccessWriter.getAttributes(this.recordSchema);
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.flush();
            this.schemaAccessWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)this.avroSchema);
        this.datumWriter.write((Object)rec, (Encoder)this.encoder);
        return this.schemaAccessWriter.getAttributes(this.recordSchema);
    }

    public void flush() throws IOException {
        this.encoder.flush();
        this.buffered.flush();
    }

    public String getMimeType() {
        return "application/avro-binary";
    }

    public void close() throws IOException {
        if (this.encoder != null) {
            this.recycleQueue.offer(this.encoder);
        }
        super.close();
    }
}

