/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.csv.CSVRecordAndFieldNames;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class CSVSchemaInference
implements SchemaInferenceEngine<CSVRecordAndFieldNames> {
    private final TimeValueInference timeValueInference;

    public CSVSchemaInference(TimeValueInference timeValueInference) {
        this.timeValueInference = timeValueInference;
    }

    @Override
    public RecordSchema inferSchema(RecordSource<CSVRecordAndFieldNames> recordSource) throws IOException {
        CSVRecordAndFieldNames recordAndFieldNames;
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        while ((recordAndFieldNames = recordSource.next()) != null) {
            this.inferSchema(recordAndFieldNames, typeMap);
        }
        return this.createSchema(typeMap);
    }

    private void inferSchema(CSVRecordAndFieldNames recordAndFieldNames, Map<String, FieldTypeInference> typeMap) {
        CSVRecord csvRecord = recordAndFieldNames.getRecord();
        for (String fieldName : recordAndFieldNames.getFieldNames()) {
            String value = csvRecord.get(fieldName);
            if (value == null) {
                return;
            }
            FieldTypeInference typeInference = typeMap.computeIfAbsent(fieldName, key -> new FieldTypeInference());
            String trimmed = this.trim(value);
            DataType dataType = this.getDataType(trimmed);
            typeInference.addPossibleDataType(dataType);
        }
    }

    private String trim(String value) {
        return value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    private DataType getDataType(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (NumberUtils.isParsable((String)value)) {
            if (value.contains(".")) {
                try {
                    double doubleValue = Double.parseDouble(value);
                    if (doubleValue > 3.4028234663852886E38 || doubleValue < (double)1.4E-45f) {
                        return RecordFieldType.DOUBLE.getDataType();
                    }
                    return RecordFieldType.FLOAT.getDataType();
                }
                catch (NumberFormatException nfe) {
                    return RecordFieldType.STRING.getDataType();
                }
            }
            try {
                long longValue = Long.parseLong(value);
                if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                    return RecordFieldType.LONG.getDataType();
                }
                return RecordFieldType.INT.getDataType();
            }
            catch (NumberFormatException nfe) {
                return RecordFieldType.STRING.getDataType();
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return RecordFieldType.BOOLEAN.getDataType();
        }
        Optional<DataType> timeDataType = this.timeValueInference.getDataType(value);
        return timeDataType.orElse(RecordFieldType.STRING.getDataType());
    }

    private RecordSchema createSchema(Map<String, FieldTypeInference> inferences) {
        ArrayList recordFields = new ArrayList(inferences.size());
        inferences.forEach((fieldName, type) -> recordFields.add(new RecordField(fieldName, type.toDataType(), true)));
        return new SimpleRecordSchema(recordFields);
    }
}

