/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.json.JsonPathRowRecordReader;
import org.apache.nifi.json.JsonPathValidator;
import org.apache.nifi.json.JsonRecordSource;
import org.apache.nifi.json.JsonSchemaInference;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"json", "jsonpath", "record", "reader", "parser"})
@CapabilityDescription(value="Parses JSON records and evaluates user-defined JSON Path's against each JSON object. While the reader expects each record to be well-formed JSON, the content of a FlowFile may consist of many records, each as a well-formed JSON array or JSON object with optional whitespace between them, such as the common 'JSON-per-line' format. If an array is encountered, each element in that array will be treated as a separate record. User-defined properties define the fields that should be extracted from the JSON in order to form the fields of a Record. Any JSON field that is not extracted via a JSONPath will not be returned in the JSON Records.")
@SeeAlso(value={JsonTreeReader.class})
@DynamicProperty(name="The field name for the record.", value="A JSONPath Expression that will be evaluated against each JSON record. The result of the JSONPath will be the value of the field whose name is the same as the property name.", description="User-defined properties identify how to extract specific fields from a JSON object in order to create a Record", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class JsonPathReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private volatile String dateFormat;
    private volatile String timeFormat;
    private volatile String timestampFormat;
    private volatile LinkedHashMap<String, JsonPath> jsonPaths;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("JsonPath Expression that indicates how to retrieve the value from a JSON Object for the '" + propertyDescriptorName + "' column").dynamic(true).required(false).addValidator((Validator)new JsonPathValidator()).build();
    }

    @OnEnabled
    public void compileJsonPaths(ConfigurationContext context) {
        this.dateFormat = context.getProperty(DateTimeUtils.DATE_FORMAT).getValue();
        this.timeFormat = context.getProperty(DateTimeUtils.TIME_FORMAT).getValue();
        this.timestampFormat = context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue();
        LinkedHashMap<String, JsonPath> compiled = new LinkedHashMap<String, JsonPath>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            String fieldName = descriptor.getName();
            String expression = context.getProperty(descriptor).getValue();
            JsonPath jsonPath = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            compiled.put(fieldName, jsonPath);
        }
        this.jsonPaths = compiled;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean pathSpecified = false;
        for (PropertyDescriptor property : validationContext.getProperties().keySet()) {
            if (!property.isDynamic()) continue;
            pathSpecified = true;
            break;
        }
        if (pathSpecified) {
            return Collections.emptyList();
        }
        return Collections.singleton(new ValidationResult.Builder().subject("JSON Paths").valid(false).explanation("No JSON Paths were specified").build());
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(SchemaInferenceUtil.INFER_SCHEMA);
        return allowableValues;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        RecordSourceFactory jsonSourceFactory = (var, in) -> new JsonRecordSource(in);
        Supplier inferenceSupplier = () -> new JsonSchemaInference(new TimeValueInference(this.dateFormat, this.timeFormat, this.timestampFormat));
        return SchemaInferenceUtil.getSchemaAccessStrategy(strategy, context, this.getLogger(), jsonSourceFactory, inferenceSupplier, () -> super.getSchemaAccessStrategy(strategy, schemaRegistry, context));
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return SchemaInferenceUtil.INFER_SCHEMA;
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws IOException, MalformedRecordException, SchemaNotFoundException {
        BufferedInputStream bufferedIn = new BufferedInputStream(in);
        RecordSchema schema = this.getSchema(variables, bufferedIn, null);
        return new JsonPathRowRecordReader(this.jsonPaths, schema, bufferedIn, logger, this.dateFormat, this.timeFormat, this.timestampFormat);
    }
}

