/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.serialization.record.StandardSchemaIdentifier;
import org.apache.nifi.syslog.SyslogRecordReader;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.parsers.SyslogParser;

@Tags(value={"syslog", "logs", "logfiles", "parse", "text", "record", "reader"})
@CapabilityDescription(value="Attempts to parses the contents of a Syslog message in accordance to RFC5424 and RFC3164. In the case of RFC5424 formatted messages, structured data is not supported, and will be returned as part of the message.Note: Be mindfull that RFC3164 is informational and a wide range of different implementations are present in the wild.")
public class SyslogReader
extends SchemaRegistryService
implements RecordReaderFactory {
    public static final String GENERIC_SYSLOG_SCHEMA_NAME = "default-syslog-schema";
    static final AllowableValue GENERIC_SYSLOG_SCHEMA = new AllowableValue("default-syslog-schema", "Use Generic Syslog Schema", "The schema will be the default Syslog schema.");
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("Specifies which character set of the Syslog messages").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    private volatile SyslogParser parser;
    private volatile RecordSchema recordSchema;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(1);
        properties.add(CHARSET);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String charsetName = context.getProperty(CHARSET).getValue();
        this.parser = new SyslogParser(Charset.forName(charsetName));
        this.recordSchema = SyslogReader.createRecordSchema();
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(GENERIC_SYSLOG_SCHEMA);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return GENERIC_SYSLOG_SCHEMA;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        return this.createAccessStrategy();
    }

    static RecordSchema createRecordSchema() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField(SyslogAttributes.PRIORITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.SEVERITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.FACILITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.VERSION.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.TIMESTAMP.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.HOSTNAME.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.BODY.key(), RecordFieldType.STRING.getDataType(), true));
        SchemaIdentifier schemaIdentifier = new StandardSchemaIdentifier.Builder().name(GENERIC_SYSLOG_SCHEMA_NAME).build();
        SimpleRecordSchema schema = new SimpleRecordSchema(fields, schemaIdentifier);
        return schema;
    }

    private SchemaAccessStrategy createAccessStrategy() {
        return new SchemaAccessStrategy(){
            private final Set<SchemaField> schemaFields = EnumSet.noneOf(SchemaField.class);

            public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) {
                return SyslogReader.this.recordSchema;
            }

            public Set<SchemaField> getSuppliedSchemaFields() {
                return this.schemaFields;
            }
        };
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws IOException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(variables, in, null);
        return new SyslogRecordReader(this.parser, in, schema);
    }
}

