/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;
import org.codehaus.jackson.JsonNode;

public class JsonPathRowRecordReader
extends AbstractJsonRowRecordReader {
    private static final Configuration STRICT_PROVIDER_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).build();
    private final ComponentLog logger;
    private final LinkedHashMap<String, JsonPath> jsonPaths;
    private final InputStream in;
    private RecordSchema schema;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public JsonPathRowRecordReader(LinkedHashMap<String, JsonPath> jsonPaths, RecordSchema schema, InputStream in, ComponentLog logger, String dateFormat, String timeFormat, String timestampFormat) throws MalformedRecordException, IOException {
        super(in, logger, dateFormat, timeFormat, timestampFormat);
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        this.schema = schema;
        this.jsonPaths = jsonPaths;
        this.in = in;
        this.logger = logger;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    @Override
    protected Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, boolean coerceTypes, boolean dropUnknownFields) {
        if (jsonNode == null) {
            return null;
        }
        DocumentContext ctx = JsonPath.using((Configuration)STRICT_PROVIDER_CONFIGURATION).parse(jsonNode.toString());
        HashMap<String, Object> values = new HashMap<String, Object>(schema.getFieldCount());
        for (Map.Entry<String, JsonPath> entry : this.jsonPaths.entrySet()) {
            Object value;
            String fieldName = entry.getKey();
            DataType desiredType = schema.getDataType(fieldName).orElse(null);
            if (desiredType == null && dropUnknownFields) continue;
            JsonPath jsonPath = entry.getValue();
            try {
                value = ctx.read(jsonPath);
            }
            catch (PathNotFoundException pnfe) {
                this.logger.debug("Evaluated JSONPath Expression {} but the path was not found; will use a null value", new Object[]{entry.getValue()});
                value = null;
            }
            Optional field = schema.getField(fieldName);
            Object defaultValue = field.map(RecordField::getDefaultValue).orElse(null);
            if (coerceTypes && desiredType != null) {
                value = this.convert(value, desiredType, fieldName, defaultValue);
            } else {
                DataType dataType = field.map(RecordField::getDataType).orElse(null);
                value = this.convert(value, dataType);
            }
            values.put(fieldName, value);
        }
        return new MapRecord(schema, values);
    }

    protected Object convert(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            Object[] array = new Object[list.size()];
            DataType elementDataType = dataType != null && dataType.getFieldType() == RecordFieldType.ARRAY ? ((ArrayDataType)dataType).getElementType() : null;
            int i = 0;
            for (Object val : list) {
                array[i++] = this.convert(val, elementDataType);
            }
            return array;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            boolean record = false;
            for (Object obj : map.values()) {
                if (!(obj instanceof JsonNode)) continue;
                record = true;
            }
            if (!record) {
                return value;
            }
            SimpleRecordSchema childSchema = null;
            if (dataType != null && dataType.getFieldType() == RecordFieldType.RECORD) {
                childSchema = ((RecordDataType)dataType).getChildSchema();
            }
            if (childSchema == null) {
                childSchema = new SimpleRecordSchema(Collections.emptyList());
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object childValue = entry.getValue();
                RecordField recordField = childSchema.getField(key).orElse(null);
                DataType childDataType = recordField == null ? null : recordField.getDataType();
                values.put(key, this.convert(childValue, childDataType));
            }
            return new MapRecord((RecordSchema)childSchema, values);
        }
        return value;
    }

    protected Object convert(Object value, DataType dataType, String fieldName, Object defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof List) {
            if (dataType.getFieldType() != RecordFieldType.ARRAY) {
                throw new IllegalTypeConversionException("Cannot convert value [" + value + "] of type Array to " + dataType);
            }
            ArrayDataType arrayType = (ArrayDataType)dataType;
            List list = (List)value;
            Object[] coercedValues = new Object[list.size()];
            int i = 0;
            for (Object rawValue : list) {
                coercedValues[i++] = this.convert(rawValue, arrayType.getElementType(), fieldName, null);
            }
            return coercedValues;
        }
        if (dataType.getFieldType() == RecordFieldType.RECORD && value instanceof Map) {
            RecordDataType recordDataType = (RecordDataType)dataType;
            RecordSchema childSchema = recordDataType.getChildSchema();
            Map rawValues = (Map)value;
            HashMap<String, Object> coercedValues = new HashMap<String, Object>();
            for (Map.Entry entry : rawValues.entrySet()) {
                String key = (String)entry.getKey();
                Optional desiredTypeOption = childSchema.getDataType(key);
                if (!desiredTypeOption.isPresent()) continue;
                Optional field = childSchema.getField(key);
                Object defaultFieldValue = field.map(RecordField::getDefaultValue).orElse(null);
                Object coercedValue = this.convert(entry.getValue(), (DataType)desiredTypeOption.get(), fieldName + "." + key, defaultFieldValue);
                coercedValues.put(key, coercedValue);
            }
            return new MapRecord(childSchema, coercedValues);
        }
        return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
    }
}

