/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.schema.access.NopSchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSchemaCacheService;
import org.apache.nifi.serialization.record.RecordSchema;

public class CacheIdSchemaAccessWriter
implements SchemaAccessWriter {
    private final RecordSchemaCacheService cache;
    private final SchemaAccessWriter delegate;

    public CacheIdSchemaAccessWriter(RecordSchemaCacheService cache, SchemaAccessWriter delegate) {
        this.cache = cache;
        this.delegate = delegate == null ? new NopSchemaAccessWriter() : delegate;
    }

    public void writeHeader(RecordSchema schema, OutputStream out) throws IOException {
        this.delegate.writeHeader(schema, out);
    }

    public Map<String, String> getAttributes(RecordSchema schema) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.delegate.getAttributes(schema));
        String identifier = this.cache.cacheSchema(schema);
        attributes.put("schema.cache.identifier", identifier);
        return attributes;
    }

    public void validateSchema(RecordSchema schema) throws SchemaNotFoundException {
        this.delegate.validateSchema(schema);
    }

    public Set<SchemaField> getRequiredSchemaFields() {
        return this.delegate.getRequiredSchemaFields();
    }
}

