/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import org.apache.nifi.cef.CEFCustomExtensionTypeResolver;
import org.apache.nifi.cef.CEFSchemaInference;

final class CEFSchemaInferenceBuilder {
    private String rawMessageField = null;
    private String invalidField = null;
    private boolean includeExtensions = false;
    private boolean includeCustomExtensions = false;
    private CEFCustomExtensionTypeResolver dataTypeResolver = CEFCustomExtensionTypeResolver.SKIPPING_RESOLVER;

    CEFSchemaInferenceBuilder() {
    }

    CEFSchemaInferenceBuilder withRawMessage(String rawMessageField) {
        this.rawMessageField = rawMessageField;
        return this;
    }

    CEFSchemaInferenceBuilder withInvalidField(String invalidField) {
        this.invalidField = invalidField;
        return this;
    }

    CEFSchemaInferenceBuilder withExtensions() {
        this.includeExtensions = true;
        return this;
    }

    CEFSchemaInferenceBuilder withCustomExtensions(CEFCustomExtensionTypeResolver dataTypeResolver) {
        this.withExtensions();
        this.includeCustomExtensions = true;
        this.dataTypeResolver = dataTypeResolver;
        return this;
    }

    CEFSchemaInference build() {
        return new CEFSchemaInference(this.includeExtensions, this.includeCustomExtensions, this.dataTypeResolver, this.rawMessageField, this.invalidField);
    }
}

