/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;

final class CEFSchemaUtil {
    private static final List<RecordField> HEADER_FIELDS = new ArrayList<RecordField>();
    private static final Set<String> EXTENSIONS_STRING;
    private static final Set<String> EXTENSIONS_INTEGER;
    private static final Set<String> EXTENSIONS_LONG;
    private static final Set<String> EXTENSIONS_FLOAT;
    private static final Set<String> EXTENSIONS_DOUBLE;
    private static final Set<String> EXTENSIONS_INET_ADDRESS;
    private static final Set<String> EXTENSIONS_IPV4_ADDRESS;
    private static final Set<String> EXTENSIONS_IPV6_ADDRESS;
    private static final Set<String> EXTENSIONS_MAC_ADDRESS;
    private static final Set<String> EXTENSIONS_TIMESTAMP;
    private static final Map<Set<String>, DataType> EXTENSION_TYPE_MAPPING;

    static List<RecordField> getHeaderFields() {
        return HEADER_FIELDS;
    }

    static Map<Set<String>, DataType> getExtensionTypeMapping() {
        return EXTENSION_TYPE_MAPPING;
    }

    private CEFSchemaUtil() {
    }

    static {
        HEADER_FIELDS.add(new RecordField("version", RecordFieldType.INT.getDataType()));
        HEADER_FIELDS.add(new RecordField("deviceVendor", RecordFieldType.STRING.getDataType()));
        HEADER_FIELDS.add(new RecordField("deviceProduct", RecordFieldType.STRING.getDataType()));
        HEADER_FIELDS.add(new RecordField("deviceVersion", RecordFieldType.STRING.getDataType()));
        HEADER_FIELDS.add(new RecordField("deviceEventClassId", RecordFieldType.STRING.getDataType()));
        HEADER_FIELDS.add(new RecordField("name", RecordFieldType.STRING.getDataType()));
        HEADER_FIELDS.add(new RecordField("severity", RecordFieldType.STRING.getDataType()));
        EXTENSIONS_STRING = new HashSet<String>(Arrays.asList("act", "app", "c6a1Label", "c6a2Label", "c6a3Label", "c6a4Label", "cfp1Label", "cfp2Label", "cfp3Label", "cfp4Label", "cn1Label", "cn2Label", "cn3Label", "cs1", "cs1Label", "cs2", "cs2Label", "cs3", "cs3Label", "cs4", "cs4Label", "cs5", "cs5Label", "cs6", "cs6Label", "destinationDnsDomain", "destinationServiceName", "destinationTranslatedAddress", "destinationTranslatedPort", "deviceCustomDate1Label", "deviceCustomDate2Label", "deviceDnsDomain", "deviceExternalId", "deviceFacility", "deviceInboundInterface", "deviceNtDomain", "deviceOutboundInterface", "deviceProcessName", "dhost", "dntdom", "dpriv", "dproc", "dtz", "duid", "duser", "dvchost", "externalId", "fileHash", "field", "filePath", "filePermission", "fileType", "flexDate1Label", "flexNumber1Label", "flexNumber2Label", "flexString1", "flexString1Label", "flexString2", "flexString2Label", "fname", "msg", "oldFileHash", "oldField", "oldFileName", "oldFilePath", "oldFilePermission", "oldFileType", "outcome", "proto", "reason", "request", "requestClientApplication", "requestContext", "requestCookies", "requestMethod", "shost", "sntdom", "sourceDnsDomain", "sourceServiceName", "spriv", "sproc", "suid", "suser", "agentDnsDomain", "agentNtDomain", "agentTranslatedZoneExternalID", "agentTranslatedZoneURI", "ahost", "aid", "at", "atz", "av", "cat", "customerExternalID", "customerURI", "destinationTranslatedZoneExternalID", "destinationTranslatedZoneURI", "destinationZoneExternalID", "destinationZoneURI", "deviceTranslatedZoneExternalID", "deviceTranslatedZoneURI", "deviceZoneExternalID", "deviceZoneURI", "rawEvent", "sourceTranslatedZoneExternalID", "sourceTranslatedZoneURI", "sourceZoneExternalID", "sourceZoneURI"));
        EXTENSIONS_INTEGER = new HashSet<String>(Arrays.asList("cnt", "deviceDirection", "dpid", "dpt", "dvcpid", "fsize", "in", "oldFileSize", "out", "sourceTranslatedPort", "spid", "spt", "type"));
        EXTENSIONS_LONG = new HashSet<String>(Arrays.asList("cn1", "cn2", "cn3", "flexNumber1", "flexNumber2", "eventId"));
        EXTENSIONS_FLOAT = new HashSet<String>(Arrays.asList("cfp1", "cfp2", "cfp3", "cfp4"));
        EXTENSIONS_DOUBLE = new HashSet<String>(Arrays.asList("dlat", "dlong", "slat", "slong"));
        EXTENSIONS_INET_ADDRESS = new HashSet<String>(Arrays.asList("agt"));
        EXTENSIONS_IPV4_ADDRESS = new HashSet<String>(Arrays.asList("deviceTranslatedAddress", "dst", "dvc", "sourceTranslatedAddress", "src", "agentTranslatedAddress"));
        EXTENSIONS_IPV6_ADDRESS = new HashSet<String>(Arrays.asList("c6a1", "c6a2", "c6a3", "c6a4"));
        EXTENSIONS_MAC_ADDRESS = new HashSet<String>(Arrays.asList("dmac", "dvcmac", "smac", "amac"));
        EXTENSIONS_TIMESTAMP = new HashSet<String>(Arrays.asList("deviceCustomDate1", "deviceCustomDate2", "end", "fileCreatedTime", "fileModificationTime", "flexDate1", "oldFileCreateTime", "oldFileModificationTime", "rt", "start", "art"));
        EXTENSION_TYPE_MAPPING = new HashMap<Set<String>, DataType>();
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_STRING, RecordFieldType.STRING.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_INTEGER, RecordFieldType.INT.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_LONG, RecordFieldType.LONG.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_FLOAT, RecordFieldType.FLOAT.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_DOUBLE, RecordFieldType.DOUBLE.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_INET_ADDRESS, RecordFieldType.STRING.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_IPV4_ADDRESS, RecordFieldType.STRING.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_IPV6_ADDRESS, RecordFieldType.STRING.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_MAC_ADDRESS, RecordFieldType.STRING.getDataType());
        EXTENSION_TYPE_MAPPING.put(EXTENSIONS_TIMESTAMP, RecordFieldType.TIMESTAMP.getDataType());
    }
}

