/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.csv.CSVRecordAndFieldNames;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.schema.inference.RecordSource;

public class CSVRecordSource
implements RecordSource<CSVRecordAndFieldNames> {
    private final Iterator<CSVRecord> csvRecordIterator;
    private final List<String> fieldNames;

    public CSVRecordSource(InputStream in, PropertyContext context, Map<String, String> variables) throws IOException {
        InputStreamReader reader;
        String charset = context.getProperty(CSVUtils.CHARSET).getValue();
        try {
            reader = new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(in)).get(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessException((Throwable)e);
        }
        CSVFormat csvFormat = CSVUtils.createCSVFormat((PropertyContext)context, variables).builder().setHeader(new String[0]).setSkipHeaderRecord(true).setTrim(true).build();
        CSVParser csvParser = new CSVParser((Reader)reader, csvFormat);
        this.fieldNames = Collections.unmodifiableList(new ArrayList(csvParser.getHeaderMap().keySet()));
        this.csvRecordIterator = csvParser.iterator();
    }

    public CSVRecordAndFieldNames next() {
        if (this.csvRecordIterator.hasNext()) {
            CSVRecord record = this.csvRecordIterator.next();
            return new CSVRecordAndFieldNames(record, this.fieldNames);
        }
        return null;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }
}

