/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;

public class XMLRecordReader
implements RecordReader {
    private final ComponentLog logger;
    private final RecordSchema schema;
    private final boolean parseXmlAttributes;
    private final String attributePrefix;
    private final String contentFieldName;
    private StartElement currentRecordStartTag;
    private final XMLEventReader xmlEventReader;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public XMLRecordReader(InputStream in, RecordSchema schema, boolean isArray, boolean parseXmlAttributes, String attributePrefix, String contentFieldName, String dateFormat, String timeFormat, String timestampFormat, ComponentLog logger) throws MalformedRecordException {
        this.schema = schema;
        this.parseXmlAttributes = parseXmlAttributes;
        this.attributePrefix = attributePrefix;
        this.contentFieldName = contentFieldName;
        this.logger = logger;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        try {
            StandardXMLEventReaderProvider provider = new StandardXMLEventReaderProvider();
            this.xmlEventReader = provider.getEventReader(new StreamSource(in));
            if (isArray) {
                this.skipNextStartTag();
            }
            this.setNextRecordStartTag();
        }
        catch (XMLStreamException e) {
            throw new MalformedRecordException("Could not parse XML", (Throwable)e);
        }
    }

    private void skipNextStartTag() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            return;
        }
    }

    private void setNextRecordStartTag() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            this.currentRecordStartTag = startElement = xmlEvent.asStartElement();
            return;
        }
        this.currentRecordStartTag = null;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        if (this.currentRecordStartTag == null) {
            return null;
        }
        try {
            Record record = this.parseRecord(this.currentRecordStartTag, this.schema, coerceTypes, dropUnknownFields);
            this.setNextRecordStartTag();
            if (record != null) {
                return record;
            }
            return new MapRecord(this.schema, Collections.EMPTY_MAP);
        }
        catch (XMLStreamException e) {
            throw new MalformedRecordException("Could not parse XML", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object parseFieldForType(StartElement startElement, String fieldName, DataType dataType, Map<String, Object> recordValues, boolean dropUnknown) throws XMLStreamException, MalformedRecordException {
        switch (dataType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case DATE: 
            case TIME: 
            case UUID: 
            case TIMESTAMP: {
                StringBuilder content = new StringBuilder();
                while (this.xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
                    if (xmlEvent.isCharacters()) {
                        Characters characters = xmlEvent.asCharacters();
                        if (characters.isWhiteSpace()) continue;
                        content.append(characters.getData());
                        continue;
                    }
                    if (xmlEvent.isEndElement()) {
                        String contentToReturn = content.toString();
                        if (StringUtils.isBlank((String)contentToReturn)) return null;
                        return DataTypeUtils.convertType((Object)content.toString(), (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
                    }
                    if (!xmlEvent.isStartElement()) continue;
                    this.skipElement();
                }
                return null;
            }
            case ARRAY: {
                DataType arrayDataType = ((ArrayDataType)dataType).getElementType();
                Object newValue = this.parseFieldForType(startElement, fieldName, arrayDataType, recordValues, dropUnknown);
                Object oldValues = recordValues.get(fieldName);
                if (newValue == null) return oldValues;
                if (oldValues == null) {
                    ArrayList<Object> arrayValues = new ArrayList<Object>();
                    arrayValues.add(newValue);
                    return arrayValues;
                }
                if (oldValues instanceof List) {
                    ((List)oldValues).add(newValue);
                    return oldValues;
                }
                ArrayList<Object> arrayValues = new ArrayList<Object>();
                arrayValues.add(oldValues);
                arrayValues.add(newValue);
                return arrayValues;
            }
            case RECORD: {
                if (!(dataType instanceof RecordDataType)) return null;
                RecordSchema childSchema = ((RecordDataType)dataType).getChildSchema();
                return this.parseRecord(startElement, childSchema, true, dropUnknown);
            }
            case MAP: {
                DataType mapDataType = ((MapDataType)dataType).getValueType();
                HashMap<String, Object> embeddedMap = new HashMap<String, Object>();
                while (this.xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
                    if (xmlEvent.isStartElement()) {
                        StartElement subStartElement = xmlEvent.asStartElement();
                        String subFieldName = subStartElement.getName().getLocalPart();
                        Object mapValue = this.parseFieldForType(subStartElement, subFieldName, mapDataType, embeddedMap, dropUnknown);
                        embeddedMap.put(subFieldName, mapValue);
                        continue;
                    }
                    if (!xmlEvent.isEndElement()) continue;
                }
                if (embeddedMap.size() <= 0) return null;
                return embeddedMap;
            }
            case CHOICE: {
                return this.parseUnknownField(startElement, false, null);
            }
        }
        return null;
    }

    private Object parseUnknownField(StartElement startElement, boolean dropUnknown, RecordSchema schema) throws XMLStreamException {
        boolean bl;
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        if (this.parseXmlAttributes) {
            this.parseAttributesForUnknownField(startElement, schema, dropUnknown, recordValues);
        }
        StringBuilder content = new StringBuilder();
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isCharacters()) {
                Characters characters = xmlEvent.asCharacters();
                if (characters.isWhiteSpace()) continue;
                content.append(characters.getData());
                continue;
            }
            if (xmlEvent.isStartElement()) {
                StartElement startElement2 = xmlEvent.asStartElement();
                String subFieldName = startElement2.getName().getLocalPart();
                if (dropUnknown) {
                    if (schema != null) {
                        Optional field = schema.getField(subFieldName);
                        if (field.isPresent()) {
                            Object value;
                            DataType typeOfArray;
                            DataType dataType = ((RecordField)field.get()).getDataType();
                            RecordSchema childSchema = null;
                            if (dataType instanceof RecordDataType) {
                                childSchema = ((RecordDataType)dataType).getChildSchema();
                            } else if (dataType instanceof ArrayDataType && (typeOfArray = ((ArrayDataType)dataType).getElementType()) instanceof RecordDataType) {
                                childSchema = ((RecordDataType)typeOfArray).getChildSchema();
                            }
                            if ((value = this.parseUnknownField(startElement2, true, childSchema)) == null) continue;
                            this.putUnknownTypeInMap(recordValues, subFieldName, value);
                            continue;
                        }
                        this.skipElement();
                        continue;
                    }
                    this.skipElement();
                    continue;
                }
                Object value = this.parseUnknownField(startElement2, dropUnknown, schema);
                if (value == null) continue;
                this.putUnknownTypeInMap(recordValues, subFieldName, value);
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            break;
        }
        for (Map.Entry entry : recordValues.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            recordValues.put((String)entry.getKey(), ((List)entry.getValue()).toArray());
        }
        boolean hasContent = content.length() > 0;
        boolean bl2 = bl = recordValues.size() > 0;
        if (hasContent) {
            if (!bl) {
                return content.toString();
            }
            if (this.contentFieldName != null) {
                recordValues.put(this.contentFieldName, content.toString());
            } else {
                this.logger.debug("Found content for a field that was supposed to be named with the value of the \"Field Name for Content\" property but the property was not set. The content was not added to the record.");
            }
            return new MapRecord((RecordSchema)new SimpleRecordSchema(Collections.emptyList()), recordValues);
        }
        if (bl) {
            return new MapRecord((RecordSchema)new SimpleRecordSchema(Collections.emptyList()), recordValues);
        }
        return null;
    }

    private void parseAttributesForUnknownField(StartElement startElement, RecordSchema schema, boolean dropUnknown, Map<String, Object> recordValues) {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            String fieldName;
            Attribute attribute = iterator.next();
            String attributeName = attribute.getName().toString();
            String string = fieldName = this.attributePrefix == null ? attributeName : this.attributePrefix + attributeName;
            if (dropUnknown) {
                Optional field;
                if (schema == null || !(field = schema.getField(attributeName)).isPresent()) continue;
                recordValues.put(fieldName, attribute.getValue());
                continue;
            }
            recordValues.put(fieldName, attribute.getValue());
        }
    }

    private Record parseRecord(StartElement startElement, RecordSchema schema, boolean coerceTypes, boolean dropUnknown) throws XMLStreamException, MalformedRecordException {
        LinkedHashMap<String, Object> recordValues = new LinkedHashMap<String, Object>();
        if (this.parseXmlAttributes) {
            this.parseAttributesForRecord(startElement, schema, coerceTypes, dropUnknown, recordValues);
        }
        StringBuilder content = new StringBuilder();
        while (this.xmlEventReader.hasNext()) {
            Characters characters;
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                Object value;
                StartElement subStartElement = xmlEvent.asStartElement();
                String fieldName = subStartElement.getName().getLocalPart();
                Optional field = schema.getField(fieldName);
                if (dropUnknown) {
                    if (field.isPresent()) {
                        Object value2;
                        DataType typeOfArray;
                        if (coerceTypes) {
                            value = this.parseFieldForType(subStartElement, fieldName, ((RecordField)field.get()).getDataType(), recordValues, true);
                            if (value == null) continue;
                            recordValues.put(fieldName, value);
                            continue;
                        }
                        DataType dataType = ((RecordField)field.get()).getDataType();
                        RecordSchema childSchema = null;
                        if (dataType instanceof RecordDataType) {
                            childSchema = ((RecordDataType)dataType).getChildSchema();
                        } else if (dataType instanceof ArrayDataType && (typeOfArray = ((ArrayDataType)dataType).getElementType()) instanceof RecordDataType) {
                            childSchema = ((RecordDataType)typeOfArray).getChildSchema();
                        }
                        if ((value2 = this.parseUnknownField(subStartElement, true, childSchema)) == null) continue;
                        this.putUnknownTypeInMap(recordValues, fieldName, value2);
                        continue;
                    }
                    this.skipElement();
                    continue;
                }
                if (coerceTypes) {
                    if (field.isPresent()) {
                        value = this.parseFieldForType(subStartElement, fieldName, ((RecordField)field.get()).getDataType(), recordValues, false);
                        if (value == null) continue;
                        recordValues.put(fieldName, value);
                        continue;
                    }
                    value = this.parseUnknownField(subStartElement, false, null);
                    if (value == null) continue;
                    this.putUnknownTypeInMap(recordValues, fieldName, value);
                    continue;
                }
                value = this.parseUnknownField(subStartElement, false, null);
                if (value == null) continue;
                this.putUnknownTypeInMap(recordValues, fieldName, value);
                continue;
            }
            if (xmlEvent.isEndElement()) break;
            if (!xmlEvent.isCharacters() || (characters = xmlEvent.asCharacters()).isWhiteSpace()) continue;
            content.append(characters.getData());
        }
        if (content.length() > 0) {
            if (this.contentFieldName != null) {
                Optional field = schema.getField(this.contentFieldName);
                if (field.isPresent()) {
                    Object value = this.parseStringForType(content.toString(), this.contentFieldName, ((RecordField)field.get()).getDataType());
                    recordValues.put(this.contentFieldName, value);
                } else {
                    this.logger.debug("Found content for a field that was supposed to be named with the value of the \"Field Name for Content\" property but no such field was present in the schema. The content was not added to the record.");
                }
            } else {
                this.logger.debug("Found content for a field that was supposed to be named with the value of the \"Field Name for Content\" property but the property was not set. The content was not added to the record.");
            }
        }
        for (Map.Entry entry : recordValues.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            recordValues.put((String)entry.getKey(), ((List)entry.getValue()).toArray());
        }
        if (recordValues.size() > 0) {
            return new MapRecord(schema, recordValues);
        }
        return null;
    }

    private void parseAttributesForRecord(StartElement startElement, RecordSchema schema, boolean coerceTypes, boolean dropUnknown, Map<String, Object> recordValues) {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            String targetFieldName;
            Attribute attribute = iterator.next();
            String attributeName = attribute.getName().toString();
            String string = targetFieldName = this.attributePrefix == null ? attributeName : this.attributePrefix + attributeName;
            if (dropUnknown) {
                Optional field = schema.getField(attributeName);
                if (!field.isPresent()) continue;
                if (coerceTypes) {
                    DataType dataType = ((RecordField)field.get()).getDataType();
                    Object value = this.parseStringForType(attribute.getValue(), attributeName, dataType);
                    if (value == null) continue;
                    recordValues.put(targetFieldName, value);
                    continue;
                }
                recordValues.put(targetFieldName, attribute.getValue());
                continue;
            }
            if (coerceTypes) {
                Optional field = schema.getField(attributeName);
                if (field.isPresent()) {
                    Object value = this.parseStringForType(attribute.getValue(), attributeName, ((RecordField)field.get()).getDataType());
                    if (value == null) continue;
                    recordValues.put(targetFieldName, value);
                    continue;
                }
                recordValues.put(targetFieldName, attribute.getValue());
                continue;
            }
            recordValues.put(targetFieldName, attribute.getValue());
        }
    }

    private void putUnknownTypeInMap(Map<String, Object> values, String fieldName, Object fieldValue) {
        Object oldValues = values.get(fieldName);
        if (oldValues != null) {
            if (oldValues instanceof List) {
                ((List)oldValues).add(fieldValue);
            } else {
                ArrayList<Object> valuesToPut = new ArrayList<Object>();
                valuesToPut.add(oldValues);
                valuesToPut.add(fieldValue);
                values.put(fieldName, valuesToPut);
            }
        } else {
            values.put(fieldName, fieldValue);
        }
    }

    private Object parseStringForType(String data, String fieldName, DataType dataType) {
        switch (dataType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return DataTypeUtils.convertType((Object)data, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
        }
        return null;
    }

    private void skipElement() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                this.skipElement();
            }
            if (!xmlEvent.isEndElement()) continue;
            return;
        }
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public void close() throws IOException {
        try {
            this.xmlEventReader.close();
        }
        catch (XMLStreamException e) {
            this.logger.error("Unable to close XMLEventReader");
        }
    }
}

