/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.nifi.xml.inference.XmlNode;
import org.apache.nifi.xml.inference.XmlNodeType;

public class XmlArrayNode
implements XmlNode {
    private final String nodeName;
    private final List<XmlNode> elements = new ArrayList<XmlNode>();

    public XmlArrayNode(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.ARRAY;
    }

    void addElement(XmlNode node) {
        this.elements.add(node);
    }

    public List<XmlNode> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public void forEach(Consumer<XmlNode> consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public String getName() {
        return this.nodeName;
    }
}

