/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.yaml;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.json.JsonTreeRowRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.yaml.YamlRecordSource;
import org.apache.nifi.yaml.YamlTreeRowRecordReader;

@Tags(value={"yaml", "tree", "record", "reader", "parser"})
@CapabilityDescription(value="Parses YAML into individual Record objects. While the reader expects each record to be well-formed YAML, the content of a FlowFile may consist of many records, each as a well-formed YAML array or YAML object. If an array is encountered, each element in that array will be treated as a separate record. If the schema that is configured contains a field that is not present in the YAML, a null value will be used. If the YAML contains a field that is not present in the schema, that field will be skipped. See the Usage of the Controller Service for more information and examples.")
public class YamlTreeReader
extends JsonTreeReader {
    private static final boolean ALLOW_COMMENTS_DISABLED = false;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.remove(AbstractJsonRowRecordReader.MAX_STRING_LENGTH);
        properties.remove(AbstractJsonRowRecordReader.ALLOW_COMMENTS);
        return properties;
    }

    @Override
    protected RecordSourceFactory<JsonNode> createJsonRecordSourceFactory() {
        return (var, in) -> new YamlRecordSource(in, this.startingFieldStrategy, this.startingFieldName);
    }

    @Override
    protected JsonTreeRowRecordReader createJsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema) throws IOException, MalformedRecordException {
        return new YamlTreeRowRecordReader(in, logger, schema, this.dateFormat, this.timeFormat, this.timestampFormat, this.startingFieldStrategy, this.startingFieldName, this.schemaApplicationStrategy, null);
    }

    @Override
    protected StreamReadConstraints buildStreamReadConstraints(ConfigurationContext context) {
        return StreamReadConstraints.defaults();
    }

    @Override
    protected boolean isAllowCommentsEnabled(ConfigurationContext context) {
        return false;
    }
}

