/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import com.fluenda.parcefone.event.CEFHandlingException;
import com.fluenda.parcefone.event.CommonEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.cef.CEFCustomExtensionTypeResolver;
import org.apache.nifi.cef.CEFSchemaUtil;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

final class CEFSchemaInference
implements SchemaInferenceEngine<CommonEvent> {
    private final boolean includeExtensions;
    private final boolean includeCustomExtensions;
    private final CEFCustomExtensionTypeResolver typeResolver;
    private final String rawMessageField;
    private final String invalidField;

    CEFSchemaInference(boolean includeExtensions, boolean includeCustomExtensions, CEFCustomExtensionTypeResolver typeResolver, String rawMessageField, String invalidField) {
        this.includeExtensions = includeExtensions;
        this.includeCustomExtensions = includeCustomExtensions;
        this.typeResolver = typeResolver;
        this.rawMessageField = rawMessageField;
        this.invalidField = invalidField;
    }

    public RecordSchema inferSchema(RecordSource<CommonEvent> recordSource) throws IOException {
        try {
            CommonEvent event;
            ArrayList<RecordField> fields = new ArrayList<RecordField>(CEFSchemaUtil.getHeaderFields());
            HashSet<String> extensionFields = new HashSet<String>();
            LinkedHashMap<String, FieldTypeInference> customExtensionTypes = new LinkedHashMap<String, FieldTypeInference>();
            while ((event = (CommonEvent)recordSource.next()) != null) {
                if (!this.includeExtensions) continue;
                for (Map.Entry field : event.getExtension(true, this.includeCustomExtensions).entrySet()) {
                    Optional<RecordField> extensionField = this.getExtensionField((String)field.getKey());
                    if (extensionField.isPresent()) {
                        if (extensionFields.contains(field.getKey())) continue;
                        extensionFields.add((String)field.getKey());
                        fields.add(extensionField.get());
                        continue;
                    }
                    if (!this.includeCustomExtensions) continue;
                    FieldTypeInference typeInference = customExtensionTypes.computeIfAbsent((String)field.getKey(), key -> new FieldTypeInference());
                    typeInference.addPossibleDataType(this.typeResolver.resolve((String)field.getValue()));
                }
            }
            ArrayList customExtensionFields = new ArrayList(customExtensionTypes.size());
            customExtensionTypes.forEach((fieldName, type) -> customExtensionFields.add(new RecordField(fieldName, type.toDataType(), true)));
            fields.addAll(customExtensionFields);
            if (this.rawMessageField != null) {
                fields.add(new RecordField(this.rawMessageField, RecordFieldType.STRING.getDataType()));
            }
            if (this.invalidField != null) {
                fields.add(new RecordField(this.invalidField, RecordFieldType.STRING.getDataType()));
            }
            return new SimpleRecordSchema(fields);
        }
        catch (CEFHandlingException e) {
            throw new IOException(e);
        }
    }

    private Optional<RecordField> getExtensionField(String fieldName) {
        for (Map.Entry<Set<String>, DataType> entry : CEFSchemaUtil.getExtensionTypeMapping().entrySet()) {
            if (!entry.getKey().contains(fieldName)) continue;
            return Optional.of(new RecordField(fieldName, entry.getValue()));
        }
        return Optional.empty();
    }
}

