/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.util.Optional;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public abstract class AbstractCSVRecordReader
implements RecordReader {
    protected final ComponentLog logger;
    protected final boolean hasHeader;
    protected final boolean ignoreHeader;
    private final boolean trimDoubleQuote;
    protected final String dateFormat;
    protected final String timeFormat;
    protected final String timestampFormat;
    protected final RecordSchema schema;

    AbstractCSVRecordReader(ComponentLog logger, RecordSchema schema, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat, boolean trimDoubleQuote) {
        this.logger = logger;
        this.schema = schema;
        this.hasHeader = hasHeader;
        this.ignoreHeader = ignoreHeader;
        this.trimDoubleQuote = trimDoubleQuote;
        this.dateFormat = dateFormat == null || dateFormat.isEmpty() ? null : dateFormat;
        this.timeFormat = timeFormat == null || timeFormat.isEmpty() ? null : timeFormat;
        this.timestampFormat = timestampFormat == null || timestampFormat.isEmpty() ? null : timestampFormat;
    }

    protected final Object convert(String value, DataType dataType, String fieldName) {
        if (dataType == null || value == null) {
            return value;
        }
        RecordFieldType type = dataType.getFieldType();
        String trimmed = !this.trimDoubleQuote && (type.equals((Object)RecordFieldType.STRING) || type.equals((Object)RecordFieldType.CHOICE)) ? value : this.trim(value);
        if (trimmed.isEmpty()) {
            return null;
        }
        return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
    }

    protected final Object convertSimpleIfPossible(String value, DataType dataType, String fieldName) {
        if (dataType == null || value == null) {
            return value;
        }
        String trimmed = !this.trimDoubleQuote && dataType.getFieldType().equals((Object)RecordFieldType.STRING) ? value : this.trim(value);
        if (trimmed.isEmpty()) {
            return null;
        }
        switch (dataType.getFieldType()) {
            case STRING: {
                return value;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                if (!DataTypeUtils.isCompatibleDataType((Object)trimmed, (DataType)dataType)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case DATE: {
                if (!DataTypeUtils.isDateTypeCompatible((Object)trimmed, (String)this.dateFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case TIME: {
                if (!DataTypeUtils.isTimeTypeCompatible((Object)trimmed, (String)this.timeFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
            case TIMESTAMP: {
                if (!DataTypeUtils.isTimestampTypeCompatible((Object)trimmed, (String)this.timestampFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, Optional.ofNullable(this.dateFormat), Optional.ofNullable(this.timeFormat), Optional.ofNullable(this.timestampFormat), (String)fieldName);
            }
        }
        return value;
    }

    protected String trim(String value) {
        return value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

