/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.nifi.csv.AbstractCSVRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class FastCSVRecordReader
extends AbstractCSVRecordReader {
    private final CsvReader csvReader;
    private final Iterator<CsvRow> csvRowIterator;
    private List<RecordField> recordFields;
    private Map<String, Integer> headerMap;
    private final boolean ignoreHeader;
    private final boolean trimDoubleQuote;
    private final CSVFormat csvFormat;

    public FastCSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat, String encoding, boolean trimDoubleQuote) throws IOException {
        super(logger, schema, hasHeader, ignoreHeader, dateFormat, timeFormat, timestampFormat, trimDoubleQuote);
        this.ignoreHeader = ignoreHeader;
        this.trimDoubleQuote = trimDoubleQuote;
        this.csvFormat = csvFormat;
        CsvReader.CsvReaderBuilder builder = CsvReader.builder().fieldSeparator(csvFormat.getDelimiterString().charAt(0)).quoteCharacter(csvFormat.getQuoteCharacter().charValue()).commentStrategy(CommentStrategy.SKIP).skipEmptyRows(csvFormat.getIgnoreEmptyLines()).errorOnDifferentFieldCount(!csvFormat.getAllowMissingColumnNames());
        if (csvFormat.getCommentMarker() != null) {
            builder.commentCharacter(csvFormat.getCommentMarker().charValue());
        }
        if (hasHeader && !ignoreHeader) {
            this.headerMap = null;
        } else {
            this.headerMap = new HashMap<String, Integer>();
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                this.headerMap.put(schema.getField(i).getFieldName(), i);
            }
        }
        this.csvReader = builder.build((Reader)new InputStreamReader(in, encoding));
        this.csvRowIterator = this.csvReader.iterator();
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        try {
            RecordSchema schema = this.getSchema();
            List<RecordField> recordFields = this.getRecordFields();
            int numFieldNames = recordFields.size();
            if (!this.csvRowIterator.hasNext()) {
                return null;
            }
            CsvRow csvRecord = this.csvRowIterator.next();
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>(recordFields.size() * 2);
            for (int i = 0; i < csvRecord.getFieldCount(); ++i) {
                String rawValue = csvRecord.getField(i);
                if (this.csvFormat.getTrim()) {
                    rawValue = rawValue.trim();
                }
                if (this.trimDoubleQuote) {
                    rawValue = this.trim(rawValue);
                }
                if (i >= numFieldNames) {
                    if (dropUnknownFields) continue;
                    values.put("unknown_field_index_" + i, rawValue);
                    continue;
                }
                RecordField recordField = recordFields.get(i);
                String rawFieldName = recordField.getFieldName();
                DataType dataType = recordField.getDataType();
                Object value = coerceTypes ? this.convert(rawValue, dataType, rawFieldName) : this.convertSimpleIfPossible(rawValue, dataType, rawFieldName);
                values.putIfAbsent(rawFieldName, value);
            }
            return new MapRecord(schema, values, coerceTypes, dropUnknownFields);
        }
        catch (Exception e) {
            throw new MalformedRecordException("Error while getting next record", (Throwable)e);
        }
    }

    private List<RecordField> getRecordFields() {
        if (this.recordFields != null) {
            return this.recordFields;
        }
        if (this.ignoreHeader) {
            this.logger.debug("With 'Ignore Header' set to true, FastCSV still reads the header and keeps track of the number of fields in the header. This will cause an error if the provided schema does not have the same number of fields, as this is not conformant to RFC-4180");
        }
        if (!this.csvRowIterator.hasNext()) {
            return Collections.emptyList();
        }
        CsvRow headerRow = this.csvRowIterator.next();
        this.headerMap = new HashMap<String, Integer>();
        for (int i = 0; i < headerRow.getFieldCount(); ++i) {
            Object rawValue = headerRow.getField(i);
            if (this.csvFormat.getTrim()) {
                rawValue = ((String)rawValue).trim();
            }
            if (this.trimDoubleQuote) {
                rawValue = this.trim((String)rawValue);
            }
            this.headerMap.put((String)rawValue, i);
        }
        TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
        for (Map.Entry entry : this.headerMap.entrySet()) {
            sortedMap.put((Integer)entry.getValue(), (String)entry.getKey());
        }
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        ArrayList arrayList = new ArrayList(sortedMap.values());
        for (String rawFieldName : arrayList) {
            Optional option = this.schema.getField(rawFieldName);
            if (option.isPresent()) {
                fields.add((RecordField)option.get());
                continue;
            }
            fields.add(new RecordField(rawFieldName, RecordFieldType.STRING.getDataType()));
        }
        this.recordFields = fields;
        return fields;
    }

    public void close() throws IOException {
        this.csvReader.close();
    }
}

