/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.grok;

import io.krakens.grok.api.GrokCompiler;
import java.io.InputStream;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceReference;

public class GrokExpressionValidator
implements Validator {
    private final GrokCompiler grokCompiler;
    private final ResourceReference patternsReference;

    public GrokExpressionValidator(ResourceReference patternsReference, GrokCompiler compiler) {
        this.patternsReference = patternsReference;
        this.grokCompiler = compiler;
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        try {
            try (InputStream in = this.getClass().getResourceAsStream("/default-grok-patterns.txt");){
                this.grokCompiler.register(in);
            }
            if (this.patternsReference != null) {
                try (InputStream patterns = this.patternsReference.read();){
                    this.grokCompiler.register(patterns);
                }
            }
            this.grokCompiler.compile(input);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Invalid Grok pattern: " + e.getMessage()).build();
        }
        return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
    }
}

