/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import com.fluenda.parcefone.event.CEFHandlingException;
import com.fluenda.parcefone.event.CommonEvent;
import com.fluenda.parcefone.parser.CEFParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

final class CEFRecordReader
implements RecordReader {
    private static final String DATE_FORMAT = "MMM dd yyyy";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATETIME_FORMAT = "MMM dd yyyy HH:mm:ss";
    private final RecordSchema schema;
    private final BufferedReader reader;
    private final CEFParser parser;
    private final ComponentLog logger;
    private final Locale locale;
    private final String rawMessageField;
    private final String invalidField;
    private final boolean includeCustomExtensions;
    private final boolean acceptEmptyExtensions;

    CEFRecordReader(InputStream inputStream, RecordSchema recordSchema, CEFParser parser, ComponentLog logger, Locale locale, String rawMessageField, String invalidField, boolean includeCustomExtensions, boolean acceptEmptyExtensions) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.schema = recordSchema;
        this.parser = parser;
        this.logger = logger;
        this.locale = locale;
        this.rawMessageField = rawMessageField;
        this.invalidField = invalidField;
        this.includeCustomExtensions = includeCustomExtensions;
        this.acceptEmptyExtensions = acceptEmptyExtensions;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        String line = this.nextLine();
        if (line == null) {
            return null;
        }
        CommonEvent event = this.parser.parse(line, false, this.acceptEmptyExtensions, this.locale);
        if (event == null) {
            this.logger.debug("Event parsing resulted no event");
            if (this.invalidField != null && !this.invalidField.isEmpty()) {
                return new MapRecord(this.schema, Collections.singletonMap(this.invalidField, line));
            }
            throw new MalformedRecordException("The following line could not be parsed by the CEF parser: " + line);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            event.getHeader().entrySet().forEach(field -> values.put((String)field.getKey(), (String)this.convertValue((String)field.getKey(), field.getValue(), coerceTypes)));
            event.getExtension(true, this.includeCustomExtensions).entrySet().forEach(field -> values.put((String)field.getKey(), (String)this.convertValue((String)field.getKey(), field.getValue(), coerceTypes)));
            for (String fieldName : this.schema.getFieldNames()) {
                if (values.containsKey(fieldName)) continue;
                values.put(fieldName, null);
            }
        }
        catch (CEFHandlingException e) {
            throw new MalformedRecordException("Error during extracting information from CEF event", (Throwable)e);
        }
        if (this.rawMessageField != null) {
            values.put(this.rawMessageField, line);
        }
        return new MapRecord(this.schema, values, true, dropUnknownFields);
    }

    private String nextLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null && line.isEmpty()) {
        }
        return line;
    }

    private Object convertValue(String fieldName, Object fieldValue, boolean coerceType) {
        DataType dataType = this.schema.getDataType(fieldName).orElse(RecordFieldType.STRING.getDataType());
        return coerceType ? this.convert(fieldValue, dataType, fieldName) : this.convertSimpleIfPossible(fieldValue, dataType, fieldName);
    }

    private Object convert(Object value, DataType dataType, String fieldName) {
        return DataTypeUtils.convertType((Object)this.prepareValue(value), (DataType)dataType, Optional.of(DATE_FORMAT), Optional.of(TIME_FORMAT), Optional.of(DATETIME_FORMAT), (String)fieldName);
    }

    private Object convertSimpleIfPossible(Object value, DataType dataType, String fieldName) {
        if (dataType == null || value == null) {
            return value;
        }
        Object preparedValue = this.prepareValue(value);
        switch (dataType.getFieldType()) {
            case STRING: {
                return preparedValue;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                if (!DataTypeUtils.isCompatibleDataType((Object)preparedValue, (DataType)dataType)) break;
                return DataTypeUtils.convertType((Object)preparedValue, (DataType)dataType, Optional.of(DATE_FORMAT), Optional.of(TIME_FORMAT), Optional.of(DATETIME_FORMAT), (String)fieldName);
            }
            case TIMESTAMP: {
                if (!DataTypeUtils.isTimestampTypeCompatible((Object)preparedValue, (String)DATETIME_FORMAT)) break;
                return DataTypeUtils.convertType((Object)preparedValue, (DataType)dataType, Optional.of(DATE_FORMAT), Optional.of(TIME_FORMAT), Optional.of(DATETIME_FORMAT), (String)fieldName);
            }
        }
        return value;
    }

    private Object prepareValue(Object value) {
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value;
    }

    public RecordSchema getSchema() throws MalformedRecordException {
        return this.schema;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

