/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.text;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;

public class FreeFormTextWriter
extends AbstractRecordSetWriter
implements RecordSetWriter {
    private static final byte NEW_LINE = 10;
    private final PropertyValue propertyValue;
    private final Charset charset;
    private final Map<String, String> variables;

    public FreeFormTextWriter(PropertyValue textPropertyValue, Charset characterSet, OutputStream out, Map<String, String> variables) {
        super((OutputStream)new BufferedOutputStream(out));
        this.propertyValue = textPropertyValue;
        this.charset = characterSet;
        this.variables = variables;
    }

    private List<String> getColumnNames(RecordSchema schema) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (RecordField field : schema.getFields()) {
            columnNames.add(field.getFieldName());
            for (String alias : field.getAliases()) {
                columnNames.add(alias);
            }
        }
        return columnNames;
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        this.write(record, this.getOutputStream(), this.getColumnNames(record.getSchema()));
        return Collections.emptyMap();
    }

    private void write(Record record, OutputStream out, List<String> columnNames) throws IOException {
        int numCols = columnNames.size();
        HashMap<String, String> values = new HashMap<String, String>(numCols);
        for (int i = 0; i < numCols; ++i) {
            String columnName = columnNames.get(i);
            String columnValue = record.getAsString(columnName);
            values.put(columnName, columnValue);
        }
        for (Map.Entry<String, String> variable : this.variables.entrySet()) {
            values.putIfAbsent(variable.getKey(), variable.getValue());
        }
        String evaluated = this.propertyValue.evaluateAttributeExpressions(values).getValue();
        out.write(evaluated.getBytes(this.charset));
        out.write(10);
    }

    public String getMimeType() {
        return "text/plain";
    }
}

