/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.inference;

import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.nifi.xml.inference.XmlNode;
import org.apache.nifi.xml.inference.XmlNodeType;

public class XmlContainerNode
implements XmlNode {
    private final String nodeName;
    private final Map<String, XmlNode> children;

    public XmlContainerNode(String nodeName, Map<String, XmlNode> children) {
        this.nodeName = nodeName;
        this.children = children;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.CONTAINER;
    }

    public XmlNode getChildNode(String fieldName) {
        return this.children.get(fieldName);
    }

    public void forEach(BiConsumer<String, XmlNode> consumer) {
        for (Map.Entry<String, XmlNode> child : this.children.entrySet()) {
            consumer.accept(child.getKey(), child.getValue());
        }
    }

    @Override
    public String getName() {
        return this.nodeName;
    }
}

