/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.nifi.avro.AvroRecordReader;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.NonCachingDatumReader;
import org.apache.nifi.serialization.record.RecordSchema;

public class AvroReaderWithEmbeddedSchema
extends AvroRecordReader {
    private final DataFileStream<GenericRecord> dataFileStream;
    private final InputStream in;
    private final Schema avroSchema;
    private final RecordSchema recordSchema;

    public AvroReaderWithEmbeddedSchema(InputStream in) throws IOException {
        this.in = in;
        this.dataFileStream = new DataFileStream(in, new NonCachingDatumReader());
        this.avroSchema = this.dataFileStream.getSchema();
        this.recordSchema = AvroTypeUtil.createSchema((Schema)this.avroSchema);
    }

    public void close() throws IOException {
        this.dataFileStream.close();
        this.in.close();
    }

    @Override
    protected GenericRecord nextAvroRecord() {
        if (!this.dataFileStream.hasNext()) {
            return null;
        }
        return (GenericRecord)this.dataFileStream.next();
    }

    public RecordSchema getSchema() {
        return this.recordSchema;
    }
}

