/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.record.Record;

public class WriteAvroResultWithSchema
extends AbstractRecordSetWriter {
    private final DataFileWriter<GenericRecord> dataFileWriter;
    private final Schema schema;

    public WriteAvroResultWithSchema(Schema schema, OutputStream out, CodecFactory codec) throws IOException {
        super(out);
        this.schema = schema;
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        this.dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        this.dataFileWriter.setCodec(codec);
        this.dataFileWriter.create(schema, out);
    }

    public void close() throws IOException {
        this.dataFileWriter.close();
    }

    public void flush() throws IOException {
        this.dataFileWriter.flush();
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)this.schema);
        this.dataFileWriter.append((Object)rec);
        return Collections.emptyMap();
    }

    public String getMimeType() {
        return "application/avro-binary";
    }
}

