/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import de.siegmar.fastcsv.writer.QuoteStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RawRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;

public class WriteFastCSVResult
extends AbstractRecordSetWriter
implements RecordSetWriter,
RawRecordWriter {
    private final RecordSchema recordSchema;
    private final SchemaAccessWriter schemaWriter;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;
    CsvWriter csvWriter;
    final OutputStreamWriter streamWriter;
    private final String[] fieldValues;
    private final boolean includeHeaderLine;
    private boolean headerWritten = false;
    private String[] fieldNames;

    public WriteFastCSVResult(CSVFormat csvFormat, RecordSchema recordSchema, SchemaAccessWriter schemaWriter, OutputStream out, String dateFormat, String timeFormat, String timestampFormat, boolean includeHeaderLine, String charSet) throws IOException {
        super(out);
        this.recordSchema = recordSchema;
        this.schemaWriter = schemaWriter;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.timestampFormat = timestampFormat;
        this.includeHeaderLine = includeHeaderLine;
        this.streamWriter = new OutputStreamWriter(out, charSet);
        CsvWriter.CsvWriterBuilder builder = CsvWriter.builder().fieldSeparator(csvFormat.getDelimiterString().charAt(0)).quoteCharacter(csvFormat.getQuoteCharacter().charValue());
        QuoteMode quoteMode = csvFormat.getQuoteMode() == null ? QuoteMode.MINIMAL : csvFormat.getQuoteMode();
        switch (quoteMode) {
            case ALL: {
                builder.quoteStrategy(QuoteStrategy.ALWAYS);
                break;
            }
            case NON_NUMERIC: {
                builder.quoteStrategy(QuoteStrategy.NON_EMPTY);
                break;
            }
            case MINIMAL: 
            case NONE: {
                builder.quoteStrategy(QuoteStrategy.REQUIRED);
            }
        }
        try {
            LineDelimiter lineDelimiter = LineDelimiter.of((String)csvFormat.getRecordSeparator());
            builder.lineDelimiter(lineDelimiter);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Line delimiter is not supported, must use LF, CR, or CRLF", iae);
        }
        if (csvFormat.getEscapeCharacter() != null && csvFormat.getEscapeCharacter().charValue() != '\"') {
            throw new IOException("Escape character must be a double-quote character (\") per the FastCSV conformance to the RFC4180 specification");
        }
        this.csvWriter = builder.build((Writer)this.streamWriter);
        this.fieldValues = new String[recordSchema.getFieldCount()];
    }

    private String getFormat(RecordField field) {
        DataType dataType = field.getDataType();
        switch (dataType.getFieldType()) {
            case DATE: {
                return this.dateFormat;
            }
            case TIME: {
                return this.timeFormat;
            }
            case TIMESTAMP: {
                return this.timestampFormat;
            }
        }
        return dataType.getFormat();
    }

    protected void onBeginRecordSet() throws IOException {
        this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        this.includeHeaderIfNecessary(null, true);
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    public void flush() throws IOException {
        this.streamWriter.flush();
    }

    public void close() throws IOException {
        this.csvWriter.close();
    }

    private String[] getFieldNames(Record record) {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        LinkedHashSet allFields = new LinkedHashSet();
        allFields.addAll(this.recordSchema.getFieldNames());
        allFields.addAll(record.getRawFieldNames());
        this.fieldNames = allFields.toArray(new String[0]);
        return this.fieldNames;
    }

    private void includeHeaderIfNecessary(Record record, boolean includeOnlySchemaFields) throws IOException {
        if (this.headerWritten || !this.includeHeaderLine) {
            return;
        }
        String[] fieldNames = includeOnlySchemaFields ? this.recordSchema.getFieldNames().toArray(new String[0]) : this.getFieldNames(record);
        this.csvWriter.writeRow(fieldNames);
        this.headerWritten = true;
    }

    public Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.includeHeaderIfNecessary(record, true);
        int i = 0;
        for (RecordField recordField : this.recordSchema.getFields()) {
            String fieldValue = this.getFieldValue(record, recordField);
            this.fieldValues[i++] = fieldValue;
        }
        this.csvWriter.writeRow(this.fieldValues);
        return this.schemaWriter.getAttributes(this.recordSchema);
    }

    private String getFieldValue(Record record, RecordField recordField) {
        return record.getAsString(recordField, this.getFormat(recordField));
    }

    public WriteResult writeRawRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaWriter.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.includeHeaderIfNecessary(record, false);
        String[] fieldNames = this.getFieldNames(record);
        String[] recordFieldValues = fieldNames.length == this.fieldValues.length ? this.fieldValues : new String[fieldNames.length];
        int i = 0;
        for (String fieldName : fieldNames) {
            Optional recordField = this.recordSchema.getField(fieldName);
            recordFieldValues[i++] = recordField.isPresent() ? record.getAsString(fieldName, this.getFormat((RecordField)recordField.get())) : record.getAsString(fieldName);
        }
        this.csvWriter.writeRow(recordFieldValues);
        Map attributes = this.schemaWriter.getAttributes(this.recordSchema);
        return WriteResult.of((int)this.incrementRecordCount(), (Map)attributes);
    }

    public String getMimeType() {
        return "text/csv";
    }
}

