/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.ReaderLookup;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"lookup", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@SeeAlso(value={ReaderLookup.class})
@CapabilityDescription(value="Provides a RecordSetWriterFactory that can be used to dynamically select another RecordSetWriterFactory. This will allow multiple RecordSetWriterFactory's to be defined and registered, and then selected dynamically at runtime by tagging FlowFiles with the attributes and referencing those attributes in the Service to Use property.")
@DynamicProperty(name="Name of the RecordSetWriter", value="A RecordSetWriterFactory controller service", expressionLanguageScope=ExpressionLanguageScope.NONE, description="")
public class RecordSetWriterLookup
extends AbstractControllerService
implements RecordSetWriterFactory {
    static final PropertyDescriptor SERVICE_TO_USE = new PropertyDescriptor.Builder().name("Service to Use").displayName("Service to Use").description("Specifies the name of the user-defined property whose associated Controller Service should be used.").required(true).defaultValue("${recordsetwriter.name}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private volatile Map<String, RecordSetWriterFactory> recordSetWriterFactoryMap;
    private volatile PropertyValue serviceToUseValue;

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The RecordSetWriterFactory  to return when '" + propertyDescriptorName + "' is the chosen Record Reader").identifiesControllerService(RecordSetWriterFactory.class).build();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(SERVICE_TO_USE);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        String selectedValue;
        PropertyValue serviceToUseValue;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        HashSet<String> serviceNames = new HashSet<String>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                serviceNames.add(descriptor.getName());
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("The current service cannot be registered as a RecordSetWriter to lookup").valid(false).build());
        }
        if (serviceNames.isEmpty()) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("At least one RecordSetWriter must be defined via dynamic properties").valid(false).build());
        }
        if (!(serviceToUseValue = context.getProperty(SERVICE_TO_USE)).isExpressionLanguagePresent() && !serviceNames.contains(selectedValue = serviceToUseValue.getValue())) {
            results.add(new ValidationResult.Builder().subject(SERVICE_TO_USE.getDisplayName()).explanation("No service is defined with the name <" + selectedValue + ">").valid(false).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap<String, RecordSetWriterFactory> serviceMap = new HashMap<String, RecordSetWriterFactory>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            RecordSetWriterFactory recordSetWriterFactory = (RecordSetWriterFactory)context.getProperty(descriptor).asControllerService(RecordSetWriterFactory.class);
            serviceMap.put(descriptor.getName(), recordSetWriterFactory);
        }
        this.recordSetWriterFactoryMap = Collections.unmodifiableMap(serviceMap);
        this.serviceToUseValue = context.getProperty(SERVICE_TO_USE);
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        return this.getRecordSetWriterFactory(variables).getSchema(variables, readSchema);
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out, Map<String, String> variables) throws SchemaNotFoundException, IOException {
        return this.getRecordSetWriterFactory(variables).createWriter(logger, schema, out, variables);
    }

    private RecordSetWriterFactory getRecordSetWriterFactory(Map<String, String> variables) {
        String serviceName = this.serviceToUseValue.evaluateAttributeExpressions(variables).getValue();
        if (serviceName.trim().isEmpty()) {
            throw new ProcessException("Unable to determine which Record Writer to use: after evaluating the property value against supplied variables, got an empty value");
        }
        RecordSetWriterFactory recordSetWriterFactory = this.recordSetWriterFactoryMap.get(serviceName);
        if (recordSetWriterFactory == null) {
            throw new ProcessException("No Record Writer was configured with the name <" + serviceName + ">");
        }
        return recordSetWriterFactory;
    }
}

