/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.sink;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.util.StringUtils;

@Tags(value={"email", "smtp", "record", "sink", "send", "write"})
@CapabilityDescription(value="Provides a RecordSinkService that can be used to send records in email using the specified writer for formatting.")
public class EmailRecordSink
extends AbstractControllerService
implements RecordSinkService {
    private static final String RFC822 = "Comma separated sequence of addresses following RFC822 syntax.";
    public static final PropertyDescriptor FROM = new PropertyDescriptor.Builder().name("from").displayName("From").description("Specifies the Email address to use as the sender. Comma separated sequence of addresses following RFC822 syntax.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TO = new PropertyDescriptor.Builder().name("to").displayName("To").description("The recipients to include in the To-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CC = new PropertyDescriptor.Builder().name("cc").displayName("CC").description("The recipients to include in the CC-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BCC = new PropertyDescriptor.Builder().name("bcc").displayName("BCC").description("The recipients to include in the BCC-Line of the email. Comma separated sequence of addresses following RFC822 syntax.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SUBJECT = new PropertyDescriptor.Builder().name("subject").displayName("Subject").description("The email subject").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("Message from NiFi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SMTP_HOSTNAME = new PropertyDescriptor.Builder().name("smtp-hostname").displayName("SMTP Hostname").description("The hostname of the SMTP Server that is used to send Email Notifications").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor SMTP_PORT = new PropertyDescriptor.Builder().name("smtp-port").displayName("SMTP Port").description("The Port used for SMTP communications").required(true).defaultValue("25").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor SMTP_AUTH = new PropertyDescriptor.Builder().name("smtp-auth").displayName("SMTP Auth").description("Flag indicating whether authentication should be used").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("true").build();
    public static final PropertyDescriptor SMTP_USERNAME = new PropertyDescriptor.Builder().name("smtp-username").displayName("SMTP Username").description("Username for the SMTP account").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).dependsOn(SMTP_AUTH, "true", new String[0]).build();
    public static final PropertyDescriptor SMTP_PASSWORD = new PropertyDescriptor.Builder().name("smtp-password").displayName("SMTP Password").description("Password for the SMTP account").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).sensitive(true).dependsOn(SMTP_AUTH, "true", new String[0]).build();
    public static final PropertyDescriptor SMTP_STARTTLS = new PropertyDescriptor.Builder().name("smtp-starttls").displayName("SMTP STARTTLS").description("Flag indicating whether STARTTLS should be enabled. If the server does not support STARTTLS, the connection continues without the use of TLS").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor SMTP_SSL = new PropertyDescriptor.Builder().name("smtp-ssl").displayName("SMTP SSL").description("Flag indicating whether SSL should be enabled").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("false").build();
    public static final PropertyDescriptor HEADER_XMAILER = new PropertyDescriptor.Builder().name("smtp-xmailer-header").displayName("SMTP X-Mailer Header").description("X-Mailer used in the header of the outgoing email").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("NiFi").build();
    private volatile RecordSetWriterFactory writerFactory;
    private static final Map<String, PropertyDescriptor> propertyToContext = new HashMap<String, PropertyDescriptor>();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(FROM, TO, CC, BCC, SUBJECT, SMTP_HOSTNAME, SMTP_PORT, SMTP_AUTH, SMTP_USERNAME, SMTP_PASSWORD, SMTP_STARTTLS, SMTP_SSL, HEADER_XMAILER, RecordSinkService.RECORD_WRITER_FACTORY));
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(context));
        String to = context.getProperty(TO).getValue();
        String cc = context.getProperty(CC).getValue();
        String bcc = context.getProperty(BCC).getValue();
        if (to == null && cc == null && bcc == null) {
            errors.add(new ValidationResult.Builder().subject("To, CC, BCC").valid(false).explanation("Must specify at least one To/CC/BCC address").build());
        }
        return errors;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.writerFactory = (RecordSetWriterFactory)context.getProperty(RECORD_WRITER_FACTORY).asControllerService(RecordSetWriterFactory.class);
    }

    public WriteResult sendData(RecordSet recordSet, Map<String, String> attributes, boolean sendZeroResults) throws IOException {
        WriteResult writeResult;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             RecordSetWriter writer = this.writerFactory.createWriter(this.getLogger(), recordSet.getSchema(), (OutputStream)out, attributes);){
            Record r;
            writer.beginRecordSet();
            while ((r = recordSet.next()) != null) {
                writer.write(r);
                writer.flush();
            }
            writeResult = writer.finishRecordSet();
            writer.flush();
            this.sendMessage(this.getConfigurationContext(), out.toString());
        }
        catch (SchemaNotFoundException e) {
            String errorMessage = String.format("RecordSetWriter could not be created because the schema was not found. The schema name for the RecordSet to write is %s", recordSet.getSchema().getSchemaName());
            throw new ProcessException(errorMessage, (Throwable)e);
        }
        return writeResult;
    }

    protected void send(Message msg) throws MessagingException {
        Transport.send((Message)msg);
    }

    private void sendMessage(ConfigurationContext context, String messageText) {
        Properties properties = this.getMailProperties(context);
        Session mailSession = this.createMailSession(properties);
        MimeMessage message = new MimeMessage(mailSession);
        try {
            message.setFrom((Address)InternetAddress.parse((String)context.getProperty(FROM).evaluateAttributeExpressions().getValue())[0]);
            InternetAddress[] toAddresses = this.toInternetAddresses(context, TO);
            message.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            InternetAddress[] ccAddresses = this.toInternetAddresses(context, CC);
            message.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            InternetAddress[] bccAddresses = this.toInternetAddresses(context, BCC);
            message.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
            message.setHeader("X-Mailer", context.getProperty(HEADER_XMAILER).evaluateAttributeExpressions().getValue());
            message.setSubject(context.getProperty(SUBJECT).evaluateAttributeExpressions().getValue());
            message.setContent((Object)messageText, "text/plain");
            message.setSentDate(new Date());
            this.send((Message)message);
        }
        catch (MessagingException | ProcessException e) {
            String errorMessage = String.format("Send Failed using SMTP Host [%s] Port [%s]", properties.get("mail.smtp.host"), properties.get("mail.smtp.port"));
            throw new RuntimeException(errorMessage, e);
        }
    }

    private Properties getMailProperties(ConfigurationContext context) {
        Properties properties = new Properties();
        for (Map.Entry<String, PropertyDescriptor> entry : propertyToContext.entrySet()) {
            String property = entry.getKey();
            String propValue = context.getProperty(entry.getValue()).evaluateAttributeExpressions().getValue();
            if (!StringUtils.isNotBlank((String)propValue)) continue;
            properties.setProperty(property, propValue);
        }
        return properties;
    }

    private Session createMailSession(final Properties properties) {
        boolean auth = Boolean.parseBoolean(properties.getProperty("mail.smtp.auth"));
        return auth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(this){

            public PasswordAuthentication getPasswordAuthentication() {
                String username = properties.getProperty("mail.smtp.user");
                String password = properties.getProperty("mail.smtp.password");
                return new PasswordAuthentication(username, password);
            }
        }) : Session.getInstance((Properties)properties);
    }

    private InternetAddress[] toInternetAddresses(ConfigurationContext context, PropertyDescriptor propertyDescriptor) throws AddressException {
        InternetAddress[] parse;
        String value = context.getProperty(propertyDescriptor).evaluateAttributeExpressions().getValue();
        if (value == null || value.isEmpty()) {
            if (propertyDescriptor.isRequired()) {
                String exceptionMsg = "Required property '" + propertyDescriptor.getDisplayName() + "' evaluates to an empty string.";
                throw new AddressException(exceptionMsg);
            }
            parse = new InternetAddress[]{};
        } else {
            try {
                parse = InternetAddress.parse((String)value);
            }
            catch (AddressException e) {
                String exceptionMsg = "Unable to parse a valid address for property '" + propertyDescriptor.getDisplayName() + "' with value '" + value + "'";
                throw new AddressException(exceptionMsg);
            }
        }
        return parse;
    }

    static {
        propertyToContext.put("mail.smtp.host", SMTP_HOSTNAME);
        propertyToContext.put("mail.smtp.port", SMTP_PORT);
        propertyToContext.put("mail.smtps.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.socketFactory.port", SMTP_PORT);
        propertyToContext.put("mail.smtp.ssl.enable", SMTP_SSL);
        propertyToContext.put("mail.smtp.auth", SMTP_AUTH);
        propertyToContext.put("mail.smtp.starttls.enable", SMTP_STARTTLS);
        propertyToContext.put("mail.smtp.user", SMTP_USERNAME);
        propertyToContext.put("mail.smtp.password", SMTP_PASSWORD);
    }
}

