/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.sink.lookup;

import java.io.IOException;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.record.sink.RecordSinkService;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.service.lookup.AbstractSingleAttributeBasedControllerServiceLookup;

@Tags(value={"record", "sink", "lookup"})
@CapabilityDescription(value="Provides a RecordSinkService that can be used to dynamically select another RecordSinkService. This service requires an attribute named 'record.sink.name' to be passed in when asking for a connection, and will throw an exception if the attribute is missing. The value of 'record.sink.name' will be used to select the RecordSinkService that has been registered with that name. This will allow multiple RecordSinkServices to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'record.sink.name' attribute. Note that this controller service is not intended for use in reporting tasks that employ RecordSinkService instances, such as QueryNiFiReportingTask.")
@DynamicProperty(name="The name to register the specified RecordSinkService", value="The RecordSinkService", description="If 'record.sink.name' attribute contains the name of the dynamic property, then the RecordSinkService (registered in the value) will be selected.", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class RecordSinkServiceLookup
extends AbstractSingleAttributeBasedControllerServiceLookup<RecordSinkService>
implements RecordSinkService {
    public static final String RECORD_SINK_NAME_ATTRIBUTE = "record.sink.name";
    RecordSinkService recordSinkService;

    protected String getLookupAttribute() {
        return RECORD_SINK_NAME_ATTRIBUTE;
    }

    public Class<RecordSinkService> getServiceType() {
        return RecordSinkService.class;
    }

    public WriteResult sendData(RecordSet recordSet, Map<String, String> attributes, boolean sendZeroResults) throws IOException {
        try {
            RecordSinkService recordSink = (RecordSinkService)this.lookupService(attributes);
            if (this.recordSinkService != recordSink) {
                this.recordSinkService = recordSink;
                this.recordSinkService.reset();
            }
            return this.recordSinkService.sendData(recordSet, attributes, sendZeroResults);
        }
        catch (ProcessException pe) {
            throw new IOException(pe);
        }
    }

    public void reset() {
        if (this.recordSinkService != null) {
            this.recordSinkService.reset();
        }
    }
}

