/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.state;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.nifi.components.state.StateMap;

public class RedisStateMap
implements StateMap {
    public static final Long DEFAULT_VERSION = new Long(-1L);
    public static final Integer DEFAULT_ENCODING = new Integer(1);
    private final Long version;
    private final Integer encodingVersion;
    private final Map<String, String> stateValues;

    private RedisStateMap(Builder builder) {
        this.version = builder.version == null ? DEFAULT_VERSION : builder.version;
        this.encodingVersion = builder.encodingVersion == null ? DEFAULT_ENCODING : builder.encodingVersion;
        this.stateValues = Collections.unmodifiableMap(new TreeMap(builder.stateValues));
        Objects.requireNonNull(this.version, "Version must be non-null");
        Objects.requireNonNull(this.encodingVersion, "Encoding Version must be non-null");
        Objects.requireNonNull(this.stateValues, "State Values must be non-null");
    }

    public long getVersion() {
        return this.version;
    }

    public String get(String key) {
        return this.stateValues.get(key);
    }

    public Map<String, String> toMap() {
        return this.stateValues;
    }

    public Integer getEncodingVersion() {
        return this.encodingVersion;
    }

    public static class Builder {
        private Long version;
        private Integer encodingVersion;
        private Map<String, String> stateValues = new TreeMap<String, String>();

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder encodingVersion(Integer encodingVersion) {
            this.encodingVersion = encodingVersion;
            return this;
        }

        public Builder stateValue(String name, String value) {
            this.stateValues.put(name, value);
            return this;
        }

        public Builder stateValues(Map<String, String> stateValues) {
            this.stateValues.clear();
            if (stateValues != null) {
                this.stateValues.putAll(stateValues);
            }
            return this;
        }

        public RedisStateMap build() {
            return new RedisStateMap(this);
        }
    }
}

