/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.script;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.record.script.AbstractScriptedRecordFactory;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;

@Tags(value={"record", "recordFactory", "script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Allows the user to provide a scripted RecordReaderFactory instance in order to read/parse/generate records from an incoming flow file.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ScriptedReader
extends AbstractScriptedRecordFactory<RecordReaderFactory>
implements RecordReaderFactory {
    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        super.onEnabled(context);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        if (this.recordFactory.get() != null) {
            try {
                return ((RecordReaderFactory)this.recordFactory.get()).createRecordReader(variables, in, logger);
            }
            catch (UndeclaredThrowableException ute) {
                throw new IOException(ute.getCause());
            }
        }
        return null;
    }

    @Override
    protected boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block10: {
            results = new HashSet<ValidationResult>();
            try {
                if (!(this.scriptEngine instanceof Invocable)) break block10;
                Invocable invocable = (Invocable)((Object)this.scriptEngine);
                ScriptEngineConfigurator configurator = this.scriptingComponentHelper.scriptEngineConfiguratorMap.get(this.scriptingComponentHelper.getScriptEngineName().toLowerCase());
                if (configurator != null) {
                    configurator.eval(this.scriptEngine, scriptBody, this.scriptingComponentHelper.getModules());
                } else {
                    this.scriptEngine.eval(scriptBody);
                }
                Object obj = this.scriptEngine.get("reader");
                if (obj != null) {
                    block12: {
                        ComponentLog logger;
                        block11: {
                            logger = this.getLogger();
                            try {
                                invocable.invokeMethod(obj, "setLogger", logger);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block11;
                                logger.debug("Configured script RecordReaderFactory does not contain a setLogger method.");
                            }
                        }
                        if (this.configurationContext != null) {
                            try {
                                invocable.invokeMethod(obj, "setConfigurationContext", this.configurationContext);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block12;
                                logger.debug("Configured script RecordReaderFactory does not contain a setConfigurationContext method.");
                            }
                        }
                    }
                    RecordReaderFactory scriptedReader = invocable.getInterface(obj, RecordReaderFactory.class);
                    this.recordFactory.set(scriptedReader);
                    break block10;
                }
                throw new ScriptException("No RecordReader was defined by the script.");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }
}

