/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public enum EncryptionMethod {
    MD5_128AES("PBEWITHMD5AND128BITAES-CBC-OPENSSL", "BC", false),
    MD5_192AES("PBEWITHMD5AND192BITAES-CBC-OPENSSL", "BC", false),
    MD5_256AES("PBEWITHMD5AND256BITAES-CBC-OPENSSL", "BC", false),
    MD5_DES("PBEWITHMD5ANDDES", "BC", false),
    MD5_RC2("PBEWITHMD5ANDRC2", "BC", false),
    SHA1_RC2("PBEWITHSHA1ANDRC2", "BC", false),
    SHA1_DES("PBEWITHSHA1ANDDES", "BC", false),
    SHA_128AES("PBEWITHSHAAND128BITAES-CBC-BC", "BC", true),
    SHA_192AES("PBEWITHSHAAND192BITAES-CBC-BC", "BC", true),
    SHA_256AES("PBEWITHSHAAND256BITAES-CBC-BC", "BC", true),
    SHA_40RC2("PBEWITHSHAAND40BITRC2-CBC", "BC", true),
    SHA_128RC2("PBEWITHSHAAND128BITRC2-CBC", "BC", true),
    SHA_40RC4("PBEWITHSHAAND40BITRC4", "BC", true),
    SHA_128RC4("PBEWITHSHAAND128BITRC4", "BC", true),
    SHA256_128AES("PBEWITHSHA256AND128BITAES-CBC-BC", "BC", true),
    SHA256_192AES("PBEWITHSHA256AND192BITAES-CBC-BC", "BC", true),
    SHA256_256AES("PBEWITHSHA256AND256BITAES-CBC-BC", "BC", true),
    SHA_2KEYTRIPLEDES("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "BC", true),
    SHA_3KEYTRIPLEDES("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "BC", true),
    SHA_TWOFISH("PBEWITHSHAANDTWOFISH-CBC", "BC", true),
    PGP("PGP", "BC", false),
    PGP_ASCII_ARMOR("PGP-ASCII-ARMOR", "BC", false);

    private final String algorithm;
    private final String provider;
    private final boolean unlimitedStrength;

    private EncryptionMethod(String algorithm, String provider, boolean unlimitedStrength) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.unlimitedStrength = unlimitedStrength;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean isUnlimitedStrength() {
        return this.unlimitedStrength;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("algorithm name", (Object)this.algorithm);
        builder.append("Requires unlimited strength JCE policy", this.unlimitedStrength);
        builder.append("Algorithm Provider", (Object)this.provider);
        return builder.toString();
    }
}

